/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.mark.points;

import java.util.Arrays;
import org.anchoranalysis.core.exception.CheckedUnsupportedOperationException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.points.BoundingBoxFromPoints;
import org.anchoranalysis.mpp.bean.regionmap.RegionMembershipUtilities;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.MarkWithPosition;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.orientation.Orientation;
import org.anchoranalysis.spatial.orientation.Orientation2D;
import org.anchoranalysis.spatial.orientation.RotationMatrix;
import org.anchoranalysis.spatial.point.Point2d;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.PointConverter;
import org.anchoranalysis.spatial.point.Tuple3d;
import org.anchoranalysis.spatial.scale.ScaleFactor;

public class RotatableBoundingBox
extends MarkWithPosition {
    private static final long serialVersionUID = 1L;
    private static final byte FLAG_SUBMARK_NONE = RegionMembershipUtilities.flagForNoRegion();
    private static final byte FLAG_SUBMARK_REGION0 = RegionMembershipUtilities.flagForRegion(0);
    private Point3d distanceToLeftBottom;
    private Point3d distanceToRightTop;
    private Orientation orientation;
    private RotationMatrix rotMatrix;
    private RotationMatrix rotMatrixInv;
    private Point3d pointRelative = new Point3d();

    public RotatableBoundingBox() {
        this.update(new Point2d(0.0, 0.0), new Point2d(0.0, 0.0), (Orientation)new Orientation2D());
    }

    @Override
    public byte isPointInside(Point3i point) {
        this.pointRelative.setX((double)point.x() - this.getPosition().x());
        this.pointRelative.setY((double)point.y() - this.getPosition().y());
        this.pointRelative.setZ((double)point.z() - this.getPosition().z());
        this.rotMatrixInv.rotatePointInplace(this.pointRelative);
        if (this.pointRelative.x() < this.distanceToLeftBottom.x() || this.pointRelative.x() >= this.distanceToRightTop.x()) {
            return FLAG_SUBMARK_NONE;
        }
        if (this.pointRelative.y() < this.distanceToLeftBottom.y() || this.pointRelative.y() >= this.distanceToRightTop.y()) {
            return FLAG_SUBMARK_NONE;
        }
        return FLAG_SUBMARK_REGION0;
    }

    public void update(Point2d distanceToLeftBottom, Point2d distanceToRightTop, Orientation orientation) {
        this.update(RotatableBoundingBox.convert3d(distanceToLeftBottom), RotatableBoundingBox.convert3d(distanceToRightTop), orientation);
    }

    private void update(Point3d distanceToLeftBottom, Point3d distanceToRightTop, Orientation orientation) {
        this.distanceToLeftBottom = distanceToLeftBottom;
        this.distanceToRightTop = distanceToRightTop;
        this.orientation = orientation;
        this.rotMatrix = orientation.getRotationMatrix();
        this.rotMatrixInv = this.rotMatrix.transpose();
    }

    @Override
    public BoundingBox boxAllRegions(Dimensions dimensions) {
        Point3d[] points = new Point3d[]{this.cornerPoint(false, false), this.cornerPoint(true, false), this.cornerPoint(false, true), this.cornerPoint(true, true)};
        try {
            BoundingBox box = BoundingBoxFromPoints.fromStream(Arrays.stream(points).map(this::rotateAddPos));
            return box.clampTo(dimensions.extent());
        }
        catch (OperationFailedException e) {
            throw new AnchorImpossibleSituationException();
        }
    }

    @Override
    public BoundingBox box(Dimensions dimensions, int regionID) {
        return this.boxAllRegions(dimensions);
    }

    @Override
    public double volume(int regionID) {
        double width = this.distanceToRightTop.x() - this.distanceToLeftBottom.x();
        double height = this.distanceToRightTop.y() - this.distanceToLeftBottom.y();
        return width * height;
    }

    @Override
    public Mark duplicate() {
        RotatableBoundingBox out = new RotatableBoundingBox();
        out.update(this.distanceToLeftBottom, this.distanceToRightTop, this.orientation);
        return out;
    }

    @Override
    public int numberRegions() {
        return 1;
    }

    @Override
    public String getName() {
        return "rotatableBoundingBox";
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int numberDimensions() {
        return 2;
    }

    private static Point3d convert3d(Point2d point) {
        return new Point3d(point.x(), point.y(), 0.0);
    }

    private Point3d cornerPoint(boolean x, boolean y) {
        return new Point3d(x ? this.distanceToLeftBottom.x() : this.distanceToRightTop.x(), y ? this.distanceToLeftBottom.y() : this.distanceToRightTop.y(), 0.0);
    }

    private Point3i rotateAddPos(Point3d point) {
        this.rotMatrix.rotatePointInplace(point);
        point.add((Tuple3d)this.getPosition());
        return PointConverter.intFromDoubleFloor((Point3d)point);
    }

    @Override
    public void scale(ScaleFactor scaleFactor) throws CheckedUnsupportedOperationException {
        super.scale(scaleFactor);
        scaleFactor.scale(this.distanceToLeftBottom);
        scaleFactor.scale(this.distanceToRightTop);
    }
}

