/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.mark.voxelized;

import java.util.List;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.feature.energy.EnergyStackWithoutParameters;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.voxel.BoundedVoxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.image.voxel.statistics.VoxelStatistics;
import org.anchoranalysis.image.voxel.statistics.VoxelStatisticsFromHistogram;
import org.anchoranalysis.math.histogram.Histogram;
import org.anchoranalysis.mpp.bean.regionmap.RegionMap;
import org.anchoranalysis.mpp.bean.regionmap.RegionMembershipWithFlags;
import org.anchoranalysis.mpp.index.IndexByChannel;
import org.anchoranalysis.mpp.index.factory.VoxelPartitionFactory;
import org.anchoranalysis.mpp.index.factory.VoxelPartitonFactoryHistogram;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.voxelized.AddVoxelsToHistogram;
import org.anchoranalysis.mpp.mark.voxelized.BufferArrayList;
import org.anchoranalysis.mpp.mark.voxelized.VoxelizedMark;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

class VoxelizedMarkHistogram
implements VoxelizedMark {
    private static final VoxelPartitionFactory<Histogram> FACTORY = new VoxelPartitonFactoryHistogram();
    private final IndexByChannel<Histogram> partitions;
    private ObjectMask object;
    private ObjectMask objectFlattened;

    public VoxelizedMarkHistogram(Mark mark, EnergyStackWithoutParameters stack, RegionMap regionMap) {
        this.partitions = new IndexByChannel();
        this.initForMark(mark, stack, regionMap);
    }

    private VoxelizedMarkHistogram(VoxelizedMarkHistogram src) {
        this.partitions = src.partitions;
    }

    @Override
    public VoxelizedMark duplicate() {
        return new VoxelizedMarkHistogram(this);
    }

    @Override
    public BoundedVoxels<UnsignedByteBuffer> voxels() {
        return this.object.boundedVoxels();
    }

    @Override
    public BoundedVoxels<UnsignedByteBuffer> voxelsMaximumIntensityProjection() {
        return this.objectFlattened.boundedVoxels();
    }

    @Override
    public BoundingBox boundingBox() {
        return this.object.boundingBox();
    }

    @Override
    public BoundingBox boundingBoxFlattened() {
        return this.objectFlattened.boundingBox();
    }

    @Override
    public VoxelStatistics statisticsForAllSlices(int channelID, int regionID) {
        return new VoxelStatisticsFromHistogram(this.partitions.get(channelID).getForAllSlices(regionID));
    }

    @Override
    public VoxelStatistics statisticsFor(int channelID, int regionID, int sliceID) {
        return new VoxelStatisticsFromHistogram(this.partitions.get(channelID).getForSlice(regionID, sliceID));
    }

    @Override
    public void cleanUp() {
        this.partitions.cleanUp(FACTORY);
    }

    @Override
    public VoxelStatistics statisticsForAllSlicesMaskSlice(int channelID, int regionID, int maskChannelID) {
        Histogram histogram = new Histogram(255);
        for (int z = 0; z < this.partitions.get(0).numSlices(); ++z) {
            Histogram histogramChannel = this.partitions.get(channelID).getForSlice(regionID, z);
            Histogram histogramMask = this.partitions.get(maskChannelID).getForSlice(regionID, z);
            if (!histogramMask.hasNonZeroCount(1)) continue;
            try {
                histogram.addHistogram(histogramChannel);
                continue;
            }
            catch (OperationFailedException e) {
                throw new AnchorImpossibleSituationException();
            }
        }
        return new VoxelStatisticsFromHistogram(histogram);
    }

    private void initForMark(Mark mark, EnergyStackWithoutParameters stack, RegionMap regionMap) {
        Dimensions dimensions = stack.dimensions();
        BoundingBox box = mark.boxAllRegions(dimensions);
        ReadableTuple3i cornerMax = box.calculateCornerMaxInclusive();
        this.object = new ObjectMask(box);
        this.objectFlattened = new ObjectMask(box.flattenZ());
        Extent localExtent = box.extent();
        this.partitions.initialize(FACTORY, stack.getNumberChannels(), regionMap.numRegions(), localExtent.z());
        UnsignedByteBuffer bufferMIP = this.getObjectFlattened().sliceBufferLocal(0);
        for (int z = box.cornerMin().z(); z <= cornerMax.z(); ++z) {
            BufferArrayList bufferArrList = new BufferArrayList();
            bufferArrList.initialize(stack, z);
            this.initForSlice(z, mark, box, cornerMax, localExtent, dimensions, bufferArrList, bufferMIP, regionMap);
        }
    }

    private void initForSlice(int z, Mark mark, BoundingBox box, ReadableTuple3i cornerMax, Extent localExtent, Dimensions dimensions, BufferArrayList bufferArrList, UnsignedByteBuffer bufferMIP, RegionMap regionMap) {
        Point3i running = new Point3i();
        running.setZ(z);
        int zLocal = z - box.cornerMin().z();
        List<RegionMembershipWithFlags> listRegionMembership = regionMap.createListMembershipWithFlags();
        UnsignedByteBuffer buffer = this.object.sliceBufferLocal(zLocal);
        for (int y = box.cornerMin().y(); y <= cornerMax.y(); ++y) {
            running.setY(y);
            int yLocal = y - box.cornerMin().y();
            for (int x = box.cornerMin().x(); x <= cornerMax.x(); ++x) {
                running.setX(x);
                int xLocal = x - box.cornerMin().x();
                int localOffset = localExtent.offset(xLocal, yLocal);
                int globalOffset = dimensions.offset(x, y);
                byte membership = mark.isPointInside(running);
                buffer.putRaw(localOffset, membership);
                bufferMIP.putRaw(localOffset, VoxelizedMarkHistogram.membershipMIP(membership, bufferMIP, localOffset));
                AddVoxelsToHistogram.addVoxels(membership, listRegionMembership, this.partitions, bufferArrList, globalOffset, zLocal);
            }
        }
    }

    private static byte membershipMIP(byte membership, UnsignedByteBuffer bufferMIP, int localOffset) {
        byte membershipMIP = bufferMIP.getRaw(localOffset);
        membershipMIP = (byte)(membershipMIP | membership);
        return membershipMIP;
    }

    public ObjectMask getObject() {
        return this.object;
    }

    public ObjectMask getObjectFlattened() {
        return this.objectFlattened;
    }
}

