/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.mark.voxelized.memo;

import org.anchoranalysis.core.cache.CachedSupplier;
import org.anchoranalysis.core.exception.AnchorNeverOccursException;
import org.anchoranalysis.feature.energy.EnergyStackWithoutParameters;
import org.anchoranalysis.mpp.bean.regionmap.RegionMap;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.voxelized.VoxelizedMark;
import org.anchoranalysis.mpp.mark.voxelized.VoxelizedMarkFactory;
import org.anchoranalysis.mpp.mark.voxelized.memo.VoxelizedMarkMemoFactory;

public class VoxelizedMarkMemo {
    private Mark mark;
    private EnergyStackWithoutParameters stack;
    private final RegionMap regionMap;
    private CachedSupplier<VoxelizedMark, AnchorNeverOccursException> cachedMark;

    public VoxelizedMarkMemo(Mark mark, EnergyStackWithoutParameters stack, RegionMap regionMap) {
        this.mark = mark;
        this.stack = stack;
        this.regionMap = regionMap;
        this.cachedMark = CachedSupplier.cacheChecked(() -> VoxelizedMarkFactory.create(mark, stack, regionMap));
    }

    public VoxelizedMark voxelized() {
        return (VoxelizedMark)this.cachedMark.get();
    }

    public void reset() {
        this.cachedMark.reset();
    }

    public void assignFrom(Mark mark) {
        this.mark = mark;
        this.reset();
    }

    public VoxelizedMarkMemo duplicateFresh() {
        return VoxelizedMarkMemoFactory.create(this.mark.duplicate(), this.stack, this.regionMap);
    }

    public Mark getMark() {
        return this.mark;
    }

    public RegionMap getRegionMap() {
        return this.regionMap;
    }
}

