/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.overlap;

import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.mpp.bean.regionmap.RegionMembershipUtilities;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.voxelized.memo.VoxelizedMarkMemo;
import org.anchoranalysis.mpp.overlap.CountIntersectingVoxels;

public class OverlapUtilities {
    public static double overlapWith(VoxelizedMarkMemo memo1, VoxelizedMarkMemo memo2, int regionID) {
        Mark mark1 = memo1.getMark();
        Mark mark2 = memo2.getMark();
        if (mark1.quickOverlap().isPresent() && mark1.quickOverlap().get().noOverlapWith(mark2, regionID)) {
            return 0.0;
        }
        byte flag = RegionMembershipUtilities.flagForRegion(regionID);
        return new CountIntersectingVoxels(flag).count(memo1.voxelized().voxels(), memo2.voxelized().voxels());
    }

    public static double overlapWithMaskGlobal(VoxelizedMarkMemo memo1, VoxelizedMarkMemo memo2, int regionID, Voxels<UnsignedByteBuffer> globalMask, byte onGlobalMask) {
        Mark mark1 = memo1.getMark();
        Mark mark2 = memo2.getMark();
        if (mark1.quickOverlap().isPresent() && mark1.quickOverlap().get().noOverlapWith(mark2, regionID)) {
            return 0.0;
        }
        byte flag = RegionMembershipUtilities.flagForRegion(regionID);
        return new CountIntersectingVoxels(flag).countMasked(memo1.voxelized().voxels(), memo2.voxelized().voxels(), globalMask, onGlobalMask);
    }

    private OverlapUtilities() {
    }
}

