/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.overlay;

import org.anchoranalysis.core.color.ColorIndex;
import org.anchoranalysis.core.color.RGBColor;
import org.anchoranalysis.mpp.bean.regionmap.RegionMembershipWithFlags;
import org.anchoranalysis.mpp.mark.ColoredMarks;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.MarkCollection;
import org.anchoranalysis.mpp.overlay.OverlayMark;
import org.anchoranalysis.overlay.Overlay;
import org.anchoranalysis.overlay.collection.ColoredOverlayCollection;
import org.anchoranalysis.overlay.collection.OverlayCollection;

public class OverlayCollectionMarkFactory {
    public static OverlayCollection createWithoutColor(MarkCollection marks, RegionMembershipWithFlags regionMembership) {
        OverlayCollection out = new OverlayCollection();
        for (int index = 0; index < marks.size(); ++index) {
            Mark mark = marks.get(index);
            out.add((Overlay)new OverlayMark(mark, regionMembership));
        }
        return out;
    }

    public static ColoredOverlayCollection createColor(ColoredMarks marks, RegionMembershipWithFlags regionMembership) {
        return OverlayCollectionMarkFactory.createColor(marks.getMarks(), (ColorIndex)marks.getColorList(), regionMembership);
    }

    private static ColoredOverlayCollection createColor(MarkCollection marks, ColorIndex colorIndex, RegionMembershipWithFlags regionMembership) {
        ColoredOverlayCollection out = new ColoredOverlayCollection();
        for (int i = 0; i < marks.size(); ++i) {
            out.add((Overlay)new OverlayMark(marks.get(i), regionMembership), colorIndex.get(i));
        }
        return out;
    }

    public static MarkCollection marksFromOverlays(OverlayCollection overlays) {
        MarkCollection out = new MarkCollection();
        for (int i = 0; i < overlays.size(); ++i) {
            Overlay overlay = overlays.get(i);
            if (!(overlay instanceof OverlayMark)) continue;
            OverlayMark overlayMark = (OverlayMark)overlay;
            out.add(overlayMark.getMark());
        }
        return out;
    }

    public static ColoredMarks marksFromOverlays(ColoredOverlayCollection overlays) {
        ColoredMarks out = new ColoredMarks();
        for (int i = 0; i < overlays.size(); ++i) {
            Overlay overlay = overlays.getOverlay(i);
            RGBColor color = overlays.getColor(i);
            if (!(overlay instanceof OverlayMark)) continue;
            OverlayMark overlayMark = (OverlayMark)overlay;
            out.add(overlayMark.getMark(), color);
        }
        return out;
    }

    private OverlayCollectionMarkFactory() {
    }
}

