/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.proposer;

import org.anchoranalysis.core.random.RandomNumberGenerator;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.mpp.bean.regionmap.RegionMap;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.voxelized.memo.VoxelizedMarkMemo;
import org.anchoranalysis.mpp.mark.voxelized.memo.VoxelizedMarkMemoFactory;
import org.anchoranalysis.mpp.proposer.error.ErrorNode;

public final class ProposerContext {
    private final RandomNumberGenerator randomNumberGenerator;
    private final EnergyStack energyStack;
    private final RegionMap regionMap;
    private final OperationContext operationContext;
    private final ErrorNode errorNode;

    public ProposerContext replaceError(ErrorNode errorNode) {
        return new ProposerContext(this.randomNumberGenerator, this.energyStack, this.regionMap, this.operationContext, errorNode);
    }

    public ProposerContext addErrorLevel(String errorMessage) {
        return new ProposerContext(this.randomNumberGenerator, this.energyStack, this.regionMap, this.operationContext, this.errorNode.add(errorMessage));
    }

    public int sampleInteger(int maxValExclusive) {
        return (int)(this.randomNumberGenerator.sampleDoubleZeroAndOne() * (double)maxValExclusive);
    }

    public Dimensions dimensions() {
        return this.energyStack.dimensions();
    }

    public VoxelizedMarkMemo create(Mark mark) {
        return VoxelizedMarkMemoFactory.create(mark, this.energyStack.withoutParameters(), this.regionMap);
    }

    public ProposerContext(RandomNumberGenerator randomNumberGenerator, EnergyStack energyStack, RegionMap regionMap, OperationContext operationContext, ErrorNode errorNode) {
        this.randomNumberGenerator = randomNumberGenerator;
        this.energyStack = energyStack;
        this.regionMap = regionMap;
        this.operationContext = operationContext;
        this.errorNode = errorNode;
    }

    public RandomNumberGenerator getRandomNumberGenerator() {
        return this.randomNumberGenerator;
    }

    public EnergyStack getEnergyStack() {
        return this.energyStack;
    }

    public RegionMap getRegionMap() {
        return this.regionMap;
    }

    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    public ErrorNode getErrorNode() {
        return this.errorNode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProposerContext)) {
            return false;
        }
        ProposerContext other = (ProposerContext)o;
        RandomNumberGenerator this$randomNumberGenerator = this.getRandomNumberGenerator();
        RandomNumberGenerator other$randomNumberGenerator = other.getRandomNumberGenerator();
        if (this$randomNumberGenerator == null ? other$randomNumberGenerator != null : !this$randomNumberGenerator.equals(other$randomNumberGenerator)) {
            return false;
        }
        EnergyStack this$energyStack = this.getEnergyStack();
        EnergyStack other$energyStack = other.getEnergyStack();
        if (this$energyStack == null ? other$energyStack != null : !this$energyStack.equals(other$energyStack)) {
            return false;
        }
        RegionMap this$regionMap = this.getRegionMap();
        RegionMap other$regionMap = other.getRegionMap();
        if (this$regionMap == null ? other$regionMap != null : !((Object)((Object)this$regionMap)).equals((Object)other$regionMap)) {
            return false;
        }
        OperationContext this$operationContext = this.getOperationContext();
        OperationContext other$operationContext = other.getOperationContext();
        if (this$operationContext == null ? other$operationContext != null : !this$operationContext.equals(other$operationContext)) {
            return false;
        }
        ErrorNode this$errorNode = this.getErrorNode();
        ErrorNode other$errorNode = other.getErrorNode();
        return !(this$errorNode == null ? other$errorNode != null : !this$errorNode.equals(other$errorNode));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RandomNumberGenerator $randomNumberGenerator = this.getRandomNumberGenerator();
        result = result * 59 + ($randomNumberGenerator == null ? 43 : $randomNumberGenerator.hashCode());
        EnergyStack $energyStack = this.getEnergyStack();
        result = result * 59 + ($energyStack == null ? 43 : $energyStack.hashCode());
        RegionMap $regionMap = this.getRegionMap();
        result = result * 59 + ($regionMap == null ? 43 : ((Object)((Object)$regionMap)).hashCode());
        OperationContext $operationContext = this.getOperationContext();
        result = result * 59 + ($operationContext == null ? 43 : $operationContext.hashCode());
        ErrorNode $errorNode = this.getErrorNode();
        result = result * 59 + ($errorNode == null ? 43 : $errorNode.hashCode());
        return result;
    }

    public String toString() {
        return "ProposerContext(randomNumberGenerator=" + this.getRandomNumberGenerator() + ", energyStack=" + this.getEnergyStack() + ", regionMap=" + (Object)((Object)this.getRegionMap()) + ", operationContext=" + this.getOperationContext() + ", errorNode=" + this.getErrorNode() + ")";
    }
}

