/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.bean.bound;

import java.io.Serializable;
import lombok.Generated;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.random.RandomNumberGenerator;

public class ResolvedBound
extends AnchorBean<ResolvedBound>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @BeanField
    private double min = 0.0;
    @BeanField
    private double max = 1.0;

    public ResolvedBound(ResolvedBound src) {
        this.min = src.min;
        this.max = src.max;
    }

    public boolean contains(double val) {
        return val >= this.min && val <= this.max;
    }

    public String getDscr() {
        return String.format("resolvedBound(min=%f,max=%f)", this.getMin(), this.getMax());
    }

    public void scale(double multFactor) {
        this.min *= multFactor;
        this.max *= multFactor;
    }

    public double randOpen(RandomNumberGenerator randomNumberGenerator) {
        return randomNumberGenerator.sampleDoubleFromRange(this.min, this.max);
    }

    public String toString() {
        return String.format("%f-%f", this.min, this.max);
    }

    @Generated
    public ResolvedBound() {
    }

    @Generated
    public ResolvedBound(double min, double max) {
        this.min = min;
        this.max = max;
    }

    @Generated
    public double getMin() {
        return this.min;
    }

    @Generated
    public void setMin(double min) {
        this.min = min;
    }

    @Generated
    public double getMax() {
        return this.max;
    }

    @Generated
    public void setMax(double max) {
        this.max = max;
    }
}

