/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.index;

import java.util.ArrayList;
import java.util.List;
import org.anchoranalysis.core.functional.FunctionalIterate;
import org.anchoranalysis.mpp.index.VoxelPartition;
import org.anchoranalysis.mpp.index.factory.VoxelPartitionFactory;

public class IndexByRegion<T> {
    private final List<VoxelPartition<T>> list;

    public IndexByRegion(VoxelPartitionFactory<T> factory, int numberRegions, int numberSlices) {
        this.list = new ArrayList<VoxelPartition<T>>(numberRegions);
        FunctionalIterate.repeat((int)numberRegions, () -> this.list.add(factory.create(numberSlices)));
    }

    public T getForAllSlices(int regionID) {
        return this.list.get(regionID).getCombined();
    }

    public T getForSlice(int regionID, int sliceID) {
        return this.list.get(regionID).getSlice(sliceID);
    }

    public void addToVoxelList(int regionID, int sliceID, int val) {
        this.list.get(regionID).addForSlice(sliceID, val);
    }

    public void cleanUp(VoxelPartitionFactory<T> factory) {
        for (int i = 0; i < this.list.size(); ++i) {
            this.list.get(i).cleanUp(factory);
        }
    }

    public int numSlices() {
        return this.list.get(0).numberSlices();
    }
}

