/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.index;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.anchoranalysis.math.histogram.Histogram;
import org.anchoranalysis.mpp.index.VoxelPartition;
import org.anchoranalysis.mpp.index.factory.VoxelPartitionFactory;

public class VoxelPartitionHistogram
implements VoxelPartition<Histogram> {
    private Histogram combined;
    private List<Histogram> list;

    public VoxelPartitionHistogram(int numberSlices, Supplier<Histogram> histogramFactory) {
        this.combined = histogramFactory.get();
        this.list = new ArrayList<Histogram>(numberSlices);
        for (int i = 0; i < numberSlices; ++i) {
            this.list.add(histogramFactory.get());
        }
    }

    @Override
    public Histogram getSlice(int sliceID) {
        return this.list.get(sliceID);
    }

    @Override
    public void addForSlice(int sliceID, int val) {
        this.list.get(sliceID).incrementValue(val);
        this.combined.incrementValue(val);
    }

    @Override
    public Histogram getCombined() {
        return this.combined;
    }

    @Override
    public void cleanUp(VoxelPartitionFactory<Histogram> factory) {
        factory.addUnused(this.combined);
        for (int i = 0; i < this.list.size(); ++i) {
            factory.addUnused(this.list.get(i));
        }
    }

    @Override
    public int numberSlices() {
        return this.list.size();
    }
}

