/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.init;

import lombok.Generated;
import org.anchoranalysis.bean.define.Define;
import org.anchoranalysis.bean.initializable.parameters.BeanInitialization;
import org.anchoranalysis.bean.initializable.property.BeanInitializer;
import org.anchoranalysis.bean.shared.dictionary.DictionaryInitialization;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.identifier.provider.store.NamedProviderStore;
import org.anchoranalysis.core.identifier.provider.store.SharedObjects;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.feature.initialization.FeatureRelatedInitialization;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.bean.nonbean.init.PopulateStoreFromDefine;
import org.anchoranalysis.mpp.bean.bound.MarkBounds;
import org.anchoranalysis.mpp.bean.proposer.MarkCollectionProposer;
import org.anchoranalysis.mpp.bean.proposer.MarkMergeProposer;
import org.anchoranalysis.mpp.bean.proposer.MarkProposer;
import org.anchoranalysis.mpp.bean.proposer.MarkSplitProposer;
import org.anchoranalysis.mpp.bean.provider.MarkCollectionProvider;
import org.anchoranalysis.mpp.init.PointsInitialization;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.MarkCollection;
import org.anchoranalysis.mpp.pair.MarkPair;
import org.anchoranalysis.mpp.pair.RandomCollection;

public class MarksInitialization
implements BeanInitialization {
    private final ImageInitialization image;
    private final PointsInitialization points;
    private final NamedProviderStore<MarkCollection> marks;
    private final NamedProviderStore<MarkCollectionProposer> markCollectionProposers;
    private final NamedProviderStore<MarkBounds> markBounds;
    private final NamedProviderStore<MarkProposer> markProposers;
    private final NamedProviderStore<MarkMergeProposer> markMergeProposers;
    private final NamedProviderStore<MarkSplitProposer> markSplitProposers;
    private final NamedProviderStore<RandomCollection<MarkPair<Mark>>> markPairs;

    public MarksInitialization(ImageInitialization image) {
        SharedObjects sharedObjects = image.sharedObjects();
        this.image = image;
        this.points = PointsInitialization.create(image, sharedObjects);
        this.marks = sharedObjects.getOrCreate(MarkCollection.class);
        this.markCollectionProposers = sharedObjects.getOrCreate(MarkCollectionProposer.class);
        this.markBounds = sharedObjects.getOrCreate(MarkBounds.class);
        this.markProposers = sharedObjects.getOrCreate(MarkProposer.class);
        this.markMergeProposers = sharedObjects.getOrCreate(MarkMergeProposer.class);
        this.markSplitProposers = sharedObjects.getOrCreate(MarkSplitProposer.class);
        this.markPairs = sharedObjects.getOrCreate(RandomCollection.class);
    }

    public FeatureRelatedInitialization feature() {
        return this.image.featuresInitialization();
    }

    public DictionaryInitialization dictionary() {
        return this.image.dictionaryInitialization();
    }

    public void populate(BeanInitializer<?> initializer, Define define, Logger logger) throws OperationFailedException {
        PopulateStoreFromDefine populater = new PopulateStoreFromDefine(define, initializer, logger);
        populater.copyWithoutInitialize(MarkBounds.class, this.markBounds);
        populater.copyInitialize(MarkProposer.class, this.markProposers);
        populater.copyInitialize(MarkCollectionProposer.class, this.markCollectionProposers);
        populater.copyInitialize(MarkSplitProposer.class, this.markSplitProposers);
        populater.copyInitialize(MarkMergeProposer.class, this.markMergeProposers);
        populater.copyWithoutInitialize(RandomCollection.class, this.markPairs);
        populater.copyProviderInitialize(MarkCollectionProvider.class, this.marks());
        this.image.populate(initializer, define, logger);
        this.points.populate(initializer, define, logger);
    }

    @Generated
    public ImageInitialization image() {
        return this.image;
    }

    @Generated
    public PointsInitialization points() {
        return this.points;
    }

    @Generated
    public NamedProviderStore<MarkCollection> marks() {
        return this.marks;
    }

    @Generated
    public NamedProviderStore<MarkCollectionProposer> markCollectionProposers() {
        return this.markCollectionProposers;
    }

    @Generated
    public NamedProviderStore<MarkBounds> markBounds() {
        return this.markBounds;
    }

    @Generated
    public NamedProviderStore<MarkProposer> markProposers() {
        return this.markProposers;
    }

    @Generated
    public NamedProviderStore<MarkMergeProposer> markMergeProposers() {
        return this.markMergeProposers;
    }

    @Generated
    public NamedProviderStore<MarkSplitProposer> markSplitProposers() {
        return this.markSplitProposers;
    }

    @Generated
    public NamedProviderStore<RandomCollection<MarkPair<Mark>>> markPairs() {
        return this.markPairs;
    }
}

