/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.mark;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import org.anchoranalysis.core.exception.CheckedUnsupportedOperationException;
import org.anchoranalysis.core.random.RandomNumberGenerator;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectCollectionFactory;
import org.anchoranalysis.mpp.bean.regionmap.RegionMap;
import org.anchoranalysis.mpp.bean.regionmap.RegionMembership;
import org.anchoranalysis.mpp.bean.regionmap.RegionMembershipWithFlags;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.scale.ScaleFactor;

public final class MarkCollection
implements Iterable<Mark>,
Serializable {
    private static final long serialVersionUID = 2398855316191681489L;
    private final List<Mark> marks;

    public MarkCollection() {
        this(new ArrayList<Mark>());
    }

    public MarkCollection(Stream<Mark> stream) {
        this(stream.toList());
    }

    public MarkCollection(Mark mark) {
        this();
        this.add(mark);
    }

    public MarkCollection shallowCopy() {
        return new MarkCollection(this.marks.stream());
    }

    public MarkCollection deepCopy() {
        return new MarkCollection(this.marks.stream().map(Mark::duplicate));
    }

    public boolean add(Mark mark) {
        return this.marks.add(mark);
    }

    public void addAll(MarkCollection marks) {
        for (Mark m : marks) {
            this.add(m);
        }
    }

    public boolean contains(Object obj) {
        return this.marks.contains(obj);
    }

    public final boolean isEmpty() {
        return this.marks.isEmpty();
    }

    public final int size() {
        return this.marks.size();
    }

    @Override
    public final Iterator<Mark> iterator() {
        return this.marks.iterator();
    }

    public String toString() {
        String newLine = System.getProperty("line.separator");
        StringBuilder s = new StringBuilder("{");
        s.append(String.format("size=%d%n", this.marks.size()));
        Iterator<Mark> i = this.marks.iterator();
        while (i.hasNext()) {
            s.append(i.next().toString());
            s.append(newLine);
        }
        s.append("}");
        s.append(newLine);
        return s.toString();
    }

    public Mark remove(int index) {
        return this.marks.remove(index);
    }

    public void removeTwo(int index1, int index2) {
        int maxIndex = Math.max(index1, index2);
        int minIndex = Math.min(index1, index2);
        this.marks.remove(maxIndex);
        this.marks.remove(minIndex);
    }

    public final int randomIndex(RandomNumberGenerator randomNumberGenerator) {
        return randomNumberGenerator.sampleIntFromRange(this.size());
    }

    public Mark get(int index) {
        return this.marks.get(index);
    }

    public final Mark randomMark(RandomNumberGenerator randomNumberGenerator) {
        return this.marks.get(this.randomIndex(randomNumberGenerator));
    }

    public final void exchange(int index, Mark markToAssign) {
        this.marks.set(index, markToAssign);
    }

    public int indexOf(Mark mark) {
        return this.marks.indexOf(mark);
    }

    public ObjectCollection deriveObjects(Dimensions dimensions, RegionMembershipWithFlags regionMembership) {
        return ObjectCollectionFactory.filterAndMapFrom(this.marks, mark -> mark.numberRegions() > regionMembership.getRegionID(), mark -> mark.deriveObject(dimensions, regionMembership, BinaryValuesByte.getDefault()));
    }

    public void scaleXY(ScaleFactor scaleFactor) throws CheckedUnsupportedOperationException {
        for (Mark mark : this.marks) {
            mark.scale(scaleFactor);
        }
    }

    public MarkCollection marksAt(Point3i point, RegionMap regionMap, int regionID) {
        MarkCollection marksOut = new MarkCollection();
        RegionMembership region = regionMap.membershipForIndex(regionID);
        byte flags = region.flags();
        for (Mark mark : this) {
            byte membership = mark.isPointInside(point);
            if (!region.isMemberFlag(membership, flags)) continue;
            marksOut.add(mark);
        }
        return marksOut;
    }

    public boolean equalsDeep(MarkCollection other) {
        if (this.size() != other.size()) {
            return false;
        }
        int i = 0;
        for (Mark m : this) {
            if (m.equalsDeep(other.get(i++))) continue;
            return false;
        }
        return true;
    }

    public Map<Integer, Mark> createIdHashMap() {
        HashMap<Integer, Mark> hashMap = new HashMap<Integer, Mark>();
        for (Mark mark : this) {
            hashMap.put(mark.getIdentifier(), mark);
        }
        return hashMap;
    }

    public int[] createIdArr() {
        int[] idArr = new int[this.size()];
        int i = 0;
        for (Mark mark : this) {
            idArr[i++] = mark.getIdentifier();
        }
        return idArr;
    }

    public Set<Mark> createSet() {
        HashSet<Mark> hashMap = new HashSet<Mark>();
        for (Mark mark : this) {
            hashMap.add(mark);
        }
        return hashMap;
    }

    public Map<Mark, Integer> createHashMapToId() {
        HashMap<Mark, Integer> hashMap = new HashMap<Mark, Integer>();
        for (int i = 0; i < this.size(); ++i) {
            hashMap.put(this.get(i), i);
        }
        return hashMap;
    }

    public MarkCollection createMerged(MarkCollection toMerge) {
        MarkCollection mergedNew = this.shallowCopy();
        Set<Mark> set = mergedNew.createSet();
        for (Mark mark : toMerge) {
            if (set.contains(mark)) continue;
            mergedNew.add(mark);
        }
        return mergedNew;
    }

    public List<BoundingBox> boxList(Dimensions dimensions, int regionID) {
        ArrayList<BoundingBox> list = new ArrayList<BoundingBox>();
        for (Mark m : this) {
            list.add(m.box(dimensions, regionID));
        }
        return list;
    }

    public Mark set(int index, Mark element) {
        return this.marks.set(index, element);
    }

    @Generated
    public MarkCollection(List<Mark> marks) {
        this.marks = marks;
    }

    @Generated
    public List<Mark> getMarks() {
        return this.marks;
    }
}

