/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.mark;

import java.io.Serializable;
import lombok.Generated;
import org.anchoranalysis.core.exception.CheckedUnsupportedOperationException;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.Tuple3d;
import org.anchoranalysis.spatial.scale.ScaleFactor;

public abstract class MarkWithPosition
extends Mark
implements Serializable {
    private static final long serialVersionUID = -6976277985708631268L;
    private Point3d position;

    protected MarkWithPosition() {
        this.position = new Point3d();
    }

    protected MarkWithPosition(MarkWithPosition src) {
        super(src);
        this.position = new Point3d((Tuple3d)src.position);
    }

    protected String positionString() {
        return String.format("[%6.1f,%6.1f,%6.1f]", this.position.x(), this.position.y(), this.position.z());
    }

    @Override
    public void scale(ScaleFactor scaleFactor) throws CheckedUnsupportedOperationException {
        scaleFactor.scale(this.position);
    }

    @Override
    public Point3d centerPoint() {
        return this.getPosition();
    }

    @Override
    public boolean equalsDeep(Mark m) {
        if (!super.equalsDeep(m)) {
            return false;
        }
        if (!(m instanceof MarkWithPosition)) {
            return false;
        }
        MarkWithPosition trgt = (MarkWithPosition)m;
        return this.position.equals((Object)trgt.position);
    }

    @Generated
    public Point3d getPosition() {
        return this.position;
    }

    @Generated
    public void setPosition(Point3d position) {
        this.position = position;
    }
}

