/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.mark.conic;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import java.io.Serializable;

class EllipsoidMatrixCalculator
implements Serializable {
    private static final long serialVersionUID = -6844865854045587235L;
    private int matNumDim;
    private double radMax;
    private double radMaxSq;
    private DoubleMatrix2D matEll;
    private DoubleMatrix1D matBBox;

    public EllipsoidMatrixCalculator(int matNumDim) {
        this.matNumDim = matNumDim;
        this.matEll = DoubleFactory2D.dense.make(matNumDim, matNumDim);
        this.matBBox = DoubleFactory1D.dense.make(matNumDim);
    }

    public EllipsoidMatrixCalculator(EllipsoidMatrixCalculator src) {
        this.matNumDim = src.matNumDim;
        this.matEll = src.matEll.copy();
        this.matBBox = src.matBBox.copy();
        this.radMax = src.radMax;
        this.radMaxSq = src.radMaxSq;
    }

    public DoubleMatrix2D getEllipsoidMatrix() {
        return this.matEll;
    }

    public DoubleMatrix1D getBoundingBoxMatrix() {
        return this.matBBox;
    }

    public double getMaximumRadius() {
        return this.radMax;
    }

    public double getMaximumRadiusSquared() {
        return this.radMaxSq;
    }

    public void update(double[] radiusArray, DoubleMatrix2D matRot) {
        DoubleMatrix2D matEllInv;
        this.radMax = 0.0;
        for (int i = 0; i < this.matNumDim; ++i) {
            double rad = radiusArray[i];
            assert (rad > 0.0);
            if (!(rad > this.radMax)) continue;
            this.radMax = rad;
        }
        this.radMaxSq = Math.pow(this.radMax, 2.0);
        DoubleMatrix2D ellpsd = DoubleFactory2D.dense.make(this.matNumDim, this.matNumDim);
        ellpsd.assign(0.0);
        for (int i = 0; i < this.matNumDim; ++i) {
            ellpsd.setQuick(i, i, Math.pow(radiusArray[i], -2.0));
        }
        DoubleMatrix2D res2 = matRot.zMult(ellpsd, null);
        res2.zMult(matRot.viewDice(), this.matEll);
        assert (!Double.isNaN(this.matEll.get(0, 0)));
        try {
            matEllInv = new Algebra().inverse(this.matEll);
        }
        catch (IllegalArgumentException e) {
            matEllInv = this.matEll;
        }
        for (int i = 0; i < this.matNumDim; ++i) {
            this.matBBox.set(i, matEllInv.get(i, i));
        }
        this.matBBox.assign(val -> Math.sqrt(Math.abs(val)) + 0.5);
        if (this.radMax > 0.0) assert (!Double.isNaN(this.matEll.get(0, 0)));
    }
}

