/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.mark.points;

import java.io.Serializable;
import lombok.Generated;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.Tuple3d;

class DistanceCalculatorToLine
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Point3d startPoint;
    private Point3d endPoint;
    private Point3d directionVector;

    public DistanceCalculatorToLine(DistanceCalculatorToLine src) {
        this.startPoint = new Point3d((Tuple3d)src.startPoint);
        this.endPoint = new Point3d((Tuple3d)src.endPoint);
        this.directionVector = new Point3d((Tuple3d)src.directionVector);
    }

    public void setPoints(Point3d startPoint, Point3d endPoint) {
        this.startPoint = new Point3d((Tuple3d)startPoint);
        this.endPoint = new Point3d((Tuple3d)endPoint);
        this.directionVector = new Point3d((Tuple3d)this.endPoint);
        this.directionVector.subtract((Tuple3d)startPoint);
    }

    public double distanceToLine(Point3i point) {
        double distanceSquared2to1 = this.endPoint.distanceSquared(this.startPoint);
        double distanceSquared1to0 = this.startPoint.distanceSquared(point);
        double firstX = this.startPoint.x() - (double)point.x();
        double firstY = this.startPoint.y() - (double)point.y();
        double firstZ = this.startPoint.z() - (double)point.z();
        double dotProduct = firstX * this.directionVector.x() + firstY * this.directionVector.y() + firstZ * this.directionVector.z();
        double num = distanceSquared2to1 * distanceSquared1to0 - Math.pow(dotProduct, 2.0);
        return num / distanceSquared2to1;
    }

    @Generated
    public DistanceCalculatorToLine() {
    }

    @Generated
    public Point3d getStartPoint() {
        return this.startPoint;
    }

    @Generated
    public Point3d getEndPoint() {
        return this.endPoint;
    }

    @Generated
    public Point3d getDirectionVector() {
        return this.directionVector;
    }
}

