/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.mark.points;

import lombok.Generated;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.points.BoundingBoxFromPoints;
import org.anchoranalysis.mpp.bean.regionmap.RegionMembershipUtilities;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.points.DistanceCalculatorToLine;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.PointConverter;
import org.anchoranalysis.spatial.point.ReadableTuple3i;
import org.anchoranalysis.spatial.point.Tuple3d;
import org.anchoranalysis.spatial.scale.ScaleFactor;

public class LineSegment
extends Mark {
    private static final long serialVersionUID = 6436383113190855927L;
    private static final byte FLAG_SUBMARK_NONE = RegionMembershipUtilities.flagForNoRegion();
    private static final byte FLAG_SUBMARK_INSIDE = RegionMembershipUtilities.flagForRegion(0);
    private double distanceToLineForInside = 0.5;
    private transient DistanceCalculatorToLine distanceCalcToLine = new DistanceCalculatorToLine();

    public LineSegment(Point3i startPoint, Point3i endPoint) {
        this.setPoints(startPoint, endPoint);
    }

    @Override
    public byte isPointInside(Point3i point) {
        if (this.distanceCalcToLine.distanceToLine(point) < this.distanceToLineForInside) {
            return FLAG_SUBMARK_INSIDE;
        }
        return FLAG_SUBMARK_NONE;
    }

    @Override
    public BoundingBox box(Dimensions dimensions, int regionID) {
        return BoundingBoxFromPoints.fromTwoPoints((Point3d)this.distanceCalcToLine.getStartPoint(), (Point3d)this.distanceCalcToLine.getEndPoint());
    }

    @Override
    public Mark duplicate() {
        LineSegment out = new LineSegment();
        out.setPoints(this.distanceCalcToLine.getStartPoint(), this.distanceCalcToLine.getEndPoint());
        return out;
    }

    @Override
    public double volume(int regionID) {
        return this.distanceCalcToLine.getStartPoint().distance(this.distanceCalcToLine.getEndPoint());
    }

    public String toString() {
        return String.format("%s-%s", this.distanceCalcToLine.getStartPoint().toString(), this.distanceCalcToLine.getEndPoint().toString());
    }

    @Override
    public int numberDimensions() {
        return 3;
    }

    @Override
    public String getName() {
        return "markLineSegment";
    }

    @Override
    public void scale(ScaleFactor scaleFactor) {
        scaleFactor.scale(this.distanceCalcToLine.getStartPoint());
        scaleFactor.scale(this.distanceCalcToLine.getEndPoint());
    }

    @Override
    public Point3d centerPoint() {
        Point3d point = new Point3d((Tuple3d)this.distanceCalcToLine.getStartPoint());
        point.add((Tuple3d)this.distanceCalcToLine.getEndPoint());
        point.scale(0.5);
        return point;
    }

    public void setPoints(Point3i startPoint, Point3i endPoint) {
        this.setPoints(PointConverter.doubleFromInt((ReadableTuple3i)startPoint), PointConverter.doubleFromInt((ReadableTuple3i)endPoint));
    }

    public void setPoints(Point3d startPoint, Point3d endPoint) {
        this.distanceCalcToLine.setPoints(startPoint, endPoint);
    }

    public Point3d getStartPoint() {
        return this.distanceCalcToLine.getStartPoint();
    }

    public Point3d getEndPoint() {
        return this.distanceCalcToLine.getEndPoint();
    }

    public Point3d getDirectionVector() {
        return this.distanceCalcToLine.getDirectionVector();
    }

    @Override
    public int numberRegions() {
        return 1;
    }

    @Override
    public BoundingBox boxAllRegions(Dimensions dimensions) {
        return this.box(dimensions, 0);
    }

    @Generated
    public LineSegment() {
    }
}

