/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.mark.points;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.point.Point3d;
import org.apache.commons.collections.ListUtils;

public abstract class PointListBase
extends Mark {
    private static final long serialVersionUID = 6520431317406007141L;
    private List<Point3d> points;
    private Point3d min;
    private Point3d max;

    protected PointListBase() {
        this.points = new ArrayList<Point3d>();
    }

    protected PointListBase(Stream<Point3d> stream) {
        this.points = stream.toList();
        this.updateAfterPointsChange();
    }

    protected void doDuplicate(PointListBase markNew) {
        markNew.points = new ArrayList<Point3d>();
        this.getPoints().forEach(markNew.points::add);
        markNew.setId(this.getIdentifier());
        markNew.updateAfterPointsChange();
    }

    public void updateAfterPointsChange() {
        assert (!this.points.isEmpty());
        this.min = PointListBase.calculateMin(this.getPoints());
        this.max = PointListBase.calculateMax(this.getPoints());
    }

    @Override
    public BoundingBox box(Dimensions dimensions, int regionID) {
        return BoundingBox.createReuse((Point3d)this.min, (Point3d)this.max);
    }

    private static Point3d calculateMin(List<Point3d> points) {
        Point3d min = new Point3d(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        for (Point3d point : points) {
            if (point.x() < min.x()) {
                min.setX(point.x());
            }
            if (point.y() < min.y()) {
                min.setY(point.y());
            }
            if (!(point.z() < min.z())) continue;
            min.setZ(point.z());
        }
        return min;
    }

    private static Point3d calculateMax(List<Point3d> points) {
        Point3d max = new Point3d(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        for (Point3d point : points) {
            if (point.x() > max.x()) {
                max.setX(point.x());
            }
            if (point.y() > max.y()) {
                max.setY(point.y());
            }
            if (!(point.z() > max.z())) continue;
            max.setZ(point.z());
        }
        return max;
    }

    protected BoundingBox box() {
        return BoundingBox.createReuse((Point3d)this.getMin(), (Point3d)this.getMax());
    }

    @Override
    public boolean equalsDeep(Mark mark) {
        if (mark == null) {
            return false;
        }
        if (mark == this) {
            return true;
        }
        if (!super.equalsDeep(mark)) {
            return false;
        }
        if (mark instanceof PointListBase) {
            PointListBase markCast = (PointListBase)mark;
            if (this.min != markCast.getMin()) {
                return false;
            }
            if (this.max != markCast.getMax()) {
                return false;
            }
            return ListUtils.isEqualList(this.points, markCast.getPoints());
        }
        return false;
    }

    @Generated
    public List<Point3d> getPoints() {
        return this.points;
    }

    @Generated
    public Point3d getMin() {
        return this.min;
    }

    @Generated
    public Point3d getMax() {
        return this.max;
    }
}

