/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.mark.points;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import org.anchoranalysis.mpp.mark.points.PointList;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.Point3f;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.PointConverter;

public class PointListFactory {
    public static PointList create(List<Point3d> points) {
        return PointListFactory.create(points, -1);
    }

    public static PointList create(List<Point3d> points, int id) {
        PointList mark = new PointList();
        mark.getPoints().addAll(points);
        mark.setId(id);
        mark.updateAfterPointsChange();
        return mark;
    }

    public static PointList createMarkFromPoints3f(List<Point3f> points) {
        return PointListFactory.createMarkFromPoints(points, PointConverter::doubleFromFloat);
    }

    public static PointList createMarkFromPoints3i(List<Point3i> points) {
        return PointListFactory.createMarkFromPoints(points, PointConverter::doubleFromInt);
    }

    private static <T> PointList createMarkFromPoints(List<T> points, Function<T, Point3d> convert) {
        Preconditions.checkArgument((!points.isEmpty() ? 1 : 0) != 0, (Object)"are empty");
        return new PointList(points.stream().map(convert));
    }

    @Generated
    private PointListFactory() {
    }
}

