/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.mark.points;

import lombok.Generated;
import org.anchoranalysis.core.functional.unchecked.IntToFloatFunction;
import org.anchoranalysis.mpp.mark.points.RotatableBoundingBox;
import org.anchoranalysis.spatial.orientation.Orientation;
import org.anchoranalysis.spatial.orientation.Orientation2D;
import org.anchoranalysis.spatial.orientation.RotationMatrix;
import org.anchoranalysis.spatial.point.Point2d;
import org.anchoranalysis.spatial.point.Point2f;
import org.anchoranalysis.spatial.point.Point2i;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.PointConverter;
import org.anchoranalysis.spatial.point.Tuple3d;

public class RotatableBoundingBoxFactory {
    public static RotatableBoundingBox create(IntToFloatFunction extractElement, Point2i anchorPoint) {
        Point2f startUnrotated = new Point2f(extractElement.applyAsFloat(3), extractElement.applyAsFloat(0));
        Point2f endUnrotated = new Point2f(extractElement.applyAsFloat(1), extractElement.applyAsFloat(2));
        float angle = extractElement.applyAsFloat(4);
        return RotatableBoundingBoxFactory.createFromPoints(startUnrotated, endUnrotated, angle, anchorPoint);
    }

    private static RotatableBoundingBox createFromPoints(Point2f startUnrotated, Point2f endUnrotated, float angle, Point2i anchorPoint) {
        Orientation2D orientation = new Orientation2D(-1.0 * (double)angle);
        Point3d endRotated = RotatableBoundingBoxFactory.rotatedPointWithOffset(endUnrotated, orientation.getRotationMatrix(), anchorPoint);
        float width = startUnrotated.x() + endUnrotated.x();
        float height = startUnrotated.y() + endUnrotated.y();
        Point3d midpoint = RotatableBoundingBoxFactory.midPointFor(width, height, angle, endRotated);
        return RotatableBoundingBoxFactory.createMarkFor(midpoint, width, height, (Orientation)orientation);
    }

    private static Point3d rotatedPointWithOffset(Point2f unrotated, RotationMatrix rotMatrix, Point2i anchorPoint) {
        Point3d point = PointConverter.double3DFromFloat((Point2f)unrotated);
        rotMatrix.rotatePointInplace(point);
        point.add((Tuple3d)PointConverter.doubleFromInt((Point2i)anchorPoint));
        return point;
    }

    private static RotatableBoundingBox createMarkFor(Point3d midpoint, float width, float height, Orientation orientation) {
        RotatableBoundingBox mark = new RotatableBoundingBox();
        mark.setPosition(midpoint);
        mark.update(new Point2d((double)(-width / 2.0f), (double)(-height / 2.0f)), new Point2d((double)(width / 2.0f), (double)(height / 2.0f)), orientation);
        return mark;
    }

    private static Point3d midPointFor(float width, float height, float angle, Point3d endRotated) {
        double cosA = Math.cos(angle);
        double sinA = Math.sin(angle);
        Point3d heightVector = new Point3d(-sinA * (double)height, -cosA * (double)height, 0.0);
        Point3d widthVector = new Point3d(-cosA * (double)width, sinA * (double)width, 0.0);
        Point3d avg = RotatableBoundingBoxFactory.meanPoint(heightVector, widthVector);
        avg.add((Tuple3d)endRotated);
        return avg;
    }

    private static Point3d meanPoint(Point3d point1, Point3d point2) {
        return new Point3d((point1.x() + point2.x()) / 2.0, (point1.y() + point2.y()) / 2.0, 0.0);
    }

    @Generated
    private RotatableBoundingBoxFactory() {
    }
}

