/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.overlay.collection;

import java.util.Iterator;
import java.util.List;
import org.anchoranalysis.core.color.ColorList;
import org.anchoranalysis.core.color.RGBColor;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.overlay.Overlay;
import org.anchoranalysis.overlay.collection.OverlayCollection;
import org.anchoranalysis.overlay.writer.DrawOverlay;
import org.anchoranalysis.spatial.box.BoundingBox;

public class ColoredOverlayCollection
implements Iterable<Overlay> {
    private OverlayCollection overlays;
    private ColorList colors;

    public ColoredOverlayCollection() {
        this.overlays = new OverlayCollection();
        this.colors = new ColorList();
    }

    public void add(Overlay overlay, RGBColor color) {
        this.colors.add(color);
        this.overlays.add(overlay);
    }

    @Override
    public Iterator<Overlay> iterator() {
        return this.overlays.iterator();
    }

    public int size() {
        return this.overlays.size();
    }

    public Overlay getOverlay(int index) {
        return this.overlays.get(index);
    }

    public RGBColor getColor(int index) {
        return this.colors.get(index);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        for (int i = 0; i < this.overlays.size(); ++i) {
            RGBColor color = this.colors.get(i);
            Overlay overlay = this.overlays.get(i);
            builder.append(String.format("col=%s\tol=%s%n", color, overlay));
        }
        builder.append("}\n");
        return builder.toString();
    }

    public ColoredOverlayCollection subsetWhereBoxIntersects(Dimensions scene, DrawOverlay drawOverlay, List<BoundingBox> toIntersectWith) {
        ColoredOverlayCollection out = new ColoredOverlayCollection();
        for (int i = 0; i < this.size(); ++i) {
            Overlay overlay = this.getOverlay(i);
            if (!overlay.box(drawOverlay, scene).intersection().existsWithAny(toIntersectWith)) continue;
            out.add(overlay, this.getColor(i));
        }
        return out;
    }

    public ColoredOverlayCollection(OverlayCollection overlays, ColorList colors) {
        this.overlays = overlays;
        this.colors = colors;
    }

    public OverlayCollection getOverlays() {
        return this.overlays;
    }

    public ColorList getColors() {
        return this.colors;
    }
}

