/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.overlay.writer;

import org.anchoranalysis.core.color.ColorIndex;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.identifier.getter.IdentifierGetter;
import org.anchoranalysis.core.identifier.getter.IdentifyFromIteration;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.object.properties.ObjectWithProperties;
import org.anchoranalysis.image.core.stack.RGBStack;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.overlay.Overlay;
import org.anchoranalysis.overlay.bean.DrawObject;
import org.anchoranalysis.overlay.collection.ColoredOverlayCollection;
import org.anchoranalysis.overlay.writer.IdentifierFromProperty;
import org.anchoranalysis.overlay.writer.IdentifyDelegateToOverlays;
import org.anchoranalysis.overlay.writer.ObjectDrawAttributes;
import org.anchoranalysis.spatial.box.BoundingBox;

public class DrawOverlay {
    private static final BinaryValuesByte BINARY_VALUES_OBJECT_MASK = BinaryValuesByte.getDefault();
    private static final IdentifyFromIteration<Overlay> IDENTIFIER_GETTER_COLOR = new IdentifyFromIteration();
    private static final String PROPERTY_COLOR_ID = "colorID";
    private final DrawObject drawObject;

    public void drawOverlays(ColoredOverlayCollection overlays, RGBStack stack, IdentifierGetter<Overlay> idGetter) throws OperationFailedException {
        BoundingBox boxContainer = new BoundingBox(stack.extent());
        try {
            ObjectDrawAttributes attributes = DrawOverlay.deriveAttributes(overlays, idGetter, new IdentifierFromProperty(PROPERTY_COLOR_ID));
            Dimensions dimensions = stack.dimensions();
            for (int i = 0; i < overlays.size(); ++i) {
                ObjectWithProperties object = DrawOverlay.extractOverlayAsObject(overlays, i, dimensions);
                this.drawObject.drawSingle(object, stack, attributes, i, boxContainer);
            }
        }
        catch (CreateException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private static ObjectWithProperties extractOverlayAsObject(ColoredOverlayCollection overlays, int index, Dimensions dimensions) throws CreateException {
        Overlay overlay = overlays.getOverlay(index);
        ObjectWithProperties object = overlay.createObject(dimensions, BINARY_VALUES_OBJECT_MASK);
        object.setProperty(PROPERTY_COLOR_ID, (Object)IDENTIFIER_GETTER_COLOR.getIdentifier((Object)overlay, index));
        return object;
    }

    private static ObjectDrawAttributes deriveAttributes(ColoredOverlayCollection overlays, IdentifierGetter<Overlay> identiferOverlay, IdentifierGetter<ObjectWithProperties> idenitifierColor) {
        IdentifyDelegateToOverlays idGetterMask = new IdentifyDelegateToOverlays(identiferOverlay, overlays, true);
        return new ObjectDrawAttributes((ColorIndex)overlays.getColors(), idGetterMask, idenitifierColor);
    }

    public DrawOverlay(DrawObject drawObject) {
        this.drawObject = drawObject;
    }
}

