/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.overlay.writer;

import org.anchoranalysis.core.color.ColorIndex;
import org.anchoranalysis.core.color.RGBColor;
import org.anchoranalysis.core.identifier.getter.IdentifierGetter;
import org.anchoranalysis.core.identifier.getter.IdentifyFromIteration;
import org.anchoranalysis.image.core.object.properties.ObjectWithProperties;

public final class ObjectDrawAttributes {
    private final ColorIndex colorIndex;
    private final IdentifierGetter<ObjectWithProperties> idGetter;
    private final IdentifierGetter<ObjectWithProperties> colorIDGetter;

    public ObjectDrawAttributes(ColorIndex colorIndex) {
        this.colorIndex = colorIndex;
        this.idGetter = new IdentifyFromIteration();
        this.colorIDGetter = new IdentifyFromIteration();
    }

    public RGBColor colorFor(ObjectWithProperties object, int index) {
        return this.colorIndex.get(this.colorIDGetter.getIdentifier((Object)object, index));
    }

    public int idFor(ObjectWithProperties object, int index) {
        return this.idGetter.getIdentifier((Object)object, index);
    }

    public ColorIndex getColorIndex() {
        return this.colorIndex;
    }

    public IdentifierGetter<ObjectWithProperties> getIdGetter() {
        return this.idGetter;
    }

    public IdentifierGetter<ObjectWithProperties> getColorIDGetter() {
        return this.colorIDGetter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectDrawAttributes)) {
            return false;
        }
        ObjectDrawAttributes other = (ObjectDrawAttributes)o;
        ColorIndex this$colorIndex = this.getColorIndex();
        ColorIndex other$colorIndex = other.getColorIndex();
        if (this$colorIndex == null ? other$colorIndex != null : !this$colorIndex.equals(other$colorIndex)) {
            return false;
        }
        IdentifierGetter<ObjectWithProperties> this$idGetter = this.getIdGetter();
        IdentifierGetter<ObjectWithProperties> other$idGetter = other.getIdGetter();
        if (this$idGetter == null ? other$idGetter != null : !this$idGetter.equals(other$idGetter)) {
            return false;
        }
        IdentifierGetter<ObjectWithProperties> this$colorIDGetter = this.getColorIDGetter();
        IdentifierGetter<ObjectWithProperties> other$colorIDGetter = other.getColorIDGetter();
        return !(this$colorIDGetter == null ? other$colorIDGetter != null : !this$colorIDGetter.equals(other$colorIDGetter));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ColorIndex $colorIndex = this.getColorIndex();
        result = result * 59 + ($colorIndex == null ? 43 : $colorIndex.hashCode());
        IdentifierGetter<ObjectWithProperties> $idGetter = this.getIdGetter();
        result = result * 59 + ($idGetter == null ? 43 : $idGetter.hashCode());
        IdentifierGetter<ObjectWithProperties> $colorIDGetter = this.getColorIDGetter();
        result = result * 59 + ($colorIDGetter == null ? 43 : $colorIDGetter.hashCode());
        return result;
    }

    public String toString() {
        return "ObjectDrawAttributes(colorIndex=" + this.getColorIndex() + ", idGetter=" + this.getIdGetter() + ", colorIDGetter=" + this.getColorIDGetter() + ")";
    }

    public ObjectDrawAttributes(ColorIndex colorIndex, IdentifierGetter<ObjectWithProperties> idGetter, IdentifierGetter<ObjectWithProperties> colorIDGetter) {
        this.colorIndex = colorIndex;
        this.idGetter = idGetter;
        this.colorIDGetter = colorIDGetter;
    }
}

