/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.annotation.bean.aggregate;

import java.util.List;
import java.util.Optional;
import org.anchoranalysis.annotation.io.AnnotationWithStrategy;
import org.anchoranalysis.annotation.io.bean.AnnotatorStrategy;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.JobExecutionException;
import org.anchoranalysis.experiment.bean.task.Task;
import org.anchoranalysis.experiment.task.InputBound;
import org.anchoranalysis.experiment.task.InputTypesExpected;
import org.anchoranalysis.experiment.task.ParametersExperiment;
import org.anchoranalysis.inference.concurrency.ConcurrencyPlan;
import org.anchoranalysis.io.output.enabled.OutputEnabledMutable;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.io.output.outputter.Outputter;
import org.anchoranalysis.plugin.annotation.bean.aggregate.AggregateSharedState;
import org.anchoranalysis.plugin.annotation.bean.aggregate.AnnotationAggregateCSVGenerator;
import org.anchoranalysis.plugin.annotation.bean.aggregate.ImageAnnotation;

public class AggregateAnnotations<S extends AnnotatorStrategy>
extends Task<AnnotationWithStrategy<S>, AggregateSharedState> {
    private static final String OUTPUT_AGGREGATED = "aggregated";

    public AggregateSharedState beforeAnyJobIsExecuted(Outputter outputter, ConcurrencyPlan concurrencyPlan, List<AnnotationWithStrategy<S>> inputs, ParametersExperiment parameters) throws ExperimentExecutionException {
        try {
            return new AggregateSharedState();
        }
        catch (CreateException e) {
            throw new ExperimentExecutionException((Throwable)e);
        }
    }

    public void doJobOnInput(InputBound<AnnotationWithStrategy<S>, AggregateSharedState> input) throws JobExecutionException {
        Optional<ImageAnnotation> annotation = this.createFromInput((AnnotationWithStrategy)input.getInput(), input.getContextJob().operationContext());
        annotation.ifPresent(annotationToAdd -> ((AggregateSharedState)input.getSharedState()).getAnnotations().add((ImageAnnotation)annotationToAdd));
    }

    public void afterAllJobsAreExecuted(AggregateSharedState sharedState, InputOutputContext context) throws ExperimentExecutionException {
        context.getOutputter().writerSelective().write(OUTPUT_AGGREGATED, AnnotationAggregateCSVGenerator::new, sharedState::getAnnotations);
    }

    private Optional<ImageAnnotation> createFromInput(AnnotationWithStrategy<S> input, OperationContext context) throws JobExecutionException {
        try {
            return input.label(context).map(label -> new ImageAnnotation(input.identifier(), (String)label));
        }
        catch (OperationFailedException exc) {
            throw new JobExecutionException((Throwable)exc);
        }
    }

    public boolean hasVeryQuickPerInputExecution() {
        return false;
    }

    public InputTypesExpected inputTypesExpected() {
        return new InputTypesExpected(AnnotationWithStrategy.class);
    }

    public OutputEnabledMutable defaultOutputs() {
        return super.defaultOutputs().addEnabledOutputFirst(new String[]{OUTPUT_AGGREGATED});
    }
}

