/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.annotation.bean.aggregate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.anchoranalysis.core.value.TypedValue;
import org.anchoranalysis.feature.io.csv.table.FeatureTableCSVGenerator;
import org.anchoranalysis.io.generator.tabular.CSVWriter;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.plugin.annotation.bean.aggregate.ImageAnnotation;

public class AnnotationAggregateCSVGenerator
extends FeatureTableCSVGenerator<List<ImageAnnotation>> {
    public AnnotationAggregateCSVGenerator() {
        super(Arrays.asList("id", "label"));
    }

    protected void writeFeaturesToCSV(CSVWriter writer, List<ImageAnnotation> allFeatureResults, List<String> headerNames) throws OutputWriteFailedException {
        writer.writeHeaders(headerNames);
        for (ImageAnnotation annotation : allFeatureResults) {
            ArrayList<TypedValue> csvRow = new ArrayList<TypedValue>();
            AnnotationAggregateCSVGenerator.addString(csvRow, annotation.getIdentifier());
            AnnotationAggregateCSVGenerator.addString(csvRow, annotation.getLabel());
            writer.writeRow(csvRow);
        }
    }

    private static void addString(List<TypedValue> csvRow, String text) {
        csvRow.add(new TypedValue(text, false));
    }
}

