/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.annotation.bean.comparer;

import java.nio.file.Path;
import org.anchoranalysis.annotation.io.bean.comparer.ComparableSource;
import org.anchoranalysis.annotation.io.image.findable.Findable;
import org.anchoranalysis.annotation.io.image.findable.Found;
import org.anchoranalysis.annotation.io.image.findable.NotFound;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.DefaultInstance;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.bean.stack.reader.StackReader;
import org.anchoranalysis.image.io.stack.input.MaskReader;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesInt;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectCollectionFactory;
import org.anchoranalysis.io.input.InputReadFailedException;
import org.anchoranalysis.io.input.bean.path.DerivePath;
import org.anchoranalysis.io.input.path.DerivePathException;

public class MaskAsObject
extends ComparableSource {
    @BeanField
    private DerivePath derivePath;
    @BeanField
    @DefaultInstance
    private StackReader stackReader;
    @BeanField
    private boolean invert = false;

    public Findable<ObjectCollection> loadAsObjects(Path reference, Dimensions dimensions, boolean debugMode, OperationContext context) throws InputReadFailedException {
        try {
            Path maskPath = this.derivePath.deriveFrom(reference, debugMode);
            if (!maskPath.toFile().exists()) {
                return new NotFound(maskPath, "No mask exists");
            }
            Mask mask = MaskReader.openMask((StackReader)this.stackReader, (Path)maskPath, (BinaryValuesInt)this.createBinaryValues(), (OperationContext)context);
            return new Found((Object)MaskAsObject.convertToObjects(mask));
        }
        catch (ImageIOException | DerivePathException e) {
            throw new InputReadFailedException(e);
        }
    }

    private BinaryValuesInt createBinaryValues() {
        if (this.invert) {
            return BinaryValuesInt.getDefault().createInverted();
        }
        return BinaryValuesInt.getDefault();
    }

    private static ObjectCollection convertToObjects(Mask mask) {
        return ObjectCollectionFactory.of((BinaryVoxels[])new BinaryVoxels[]{mask.binaryVoxels()});
    }

    public DerivePath getDerivePath() {
        return this.derivePath;
    }

    public void setDerivePath(DerivePath derivePath) {
        this.derivePath = derivePath;
    }

    public StackReader getStackReader() {
        return this.stackReader;
    }

    public void setStackReader(StackReader stackReader) {
        this.stackReader = stackReader;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public void setInvert(boolean invert) {
        this.invert = invert;
    }
}

