/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.annotation.bean.comparer;

import java.nio.file.Path;
import org.anchoranalysis.annotation.io.bean.comparer.ComparableSource;
import org.anchoranalysis.annotation.io.image.findable.Findable;
import org.anchoranalysis.annotation.io.image.findable.Found;
import org.anchoranalysis.annotation.io.image.findable.NotFound;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.serialize.DeserializationFailedException;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.io.object.input.ObjectCollectionReader;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.io.input.InputReadFailedException;
import org.anchoranalysis.io.input.bean.path.DerivePath;
import org.anchoranalysis.io.input.path.DerivePathException;

public class Objects
extends ComparableSource {
    @BeanField
    private DerivePath derivePath;

    public Findable<ObjectCollection> loadAsObjects(Path filePathSource, Dimensions dimensions, boolean debugMode, OperationContext context) throws InputReadFailedException {
        try {
            Path objectsPath = this.derivePath.deriveFrom(filePathSource, debugMode);
            if (!objectsPath.toFile().exists()) {
                return new NotFound(objectsPath, "No objects exist");
            }
            return new Found((Object)ObjectCollectionReader.createFromPath((Path)objectsPath, (OperationContext)context));
        }
        catch (DeserializationFailedException | DerivePathException e) {
            throw new InputReadFailedException(e);
        }
    }

    public DerivePath getDerivePath() {
        return this.derivePath;
    }

    public void setDerivePath(DerivePath derivePath) {
        this.derivePath = derivePath;
    }
}

