/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.annotation.bean.comparison;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.annotation.io.comparer.StatisticsToExport;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.value.TypedValue;
import org.anchoranalysis.io.generator.tabular.CSVWriter;
import org.anchoranalysis.io.input.InputFromManager;
import org.anchoranalysis.io.input.InputReadFailedException;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.outputter.Outputter;
import org.anchoranalysis.io.output.outputter.OutputterChecked;
import org.anchoranalysis.plugin.annotation.bean.comparison.SplitString;

class CSVAssignment {
    private boolean includeDescriptiveSplit;
    private int maxSplitGroups;
    private Optional<CSVWriter> writer;
    private boolean firstRow = true;

    public CSVAssignment(Outputter outputter, String outputName, boolean includeDescriptiveSplit, int maxSplitGroups) throws OutputWriteFailedException {
        this.includeDescriptiveSplit = includeDescriptiveSplit;
        this.maxSplitGroups = maxSplitGroups;
        this.writer = CSVWriter.createFromOutputter((String)outputName, (OutputterChecked)outputter.getChecked());
    }

    public synchronized void writeStatisticsForImage(StatisticsToExport comparison, SplitString descriptiveSplit, InputFromManager input) throws OperationFailedException {
        if (!this.writer.isPresent() || !this.writer.get().isOutputEnabled()) {
            return;
        }
        if (this.firstRow) {
            this.firstRow = false;
            this.writer.get().writeHeaders(this.createHeaders(comparison));
        }
        this.writer.get().writeRow(this.createValues(comparison, input, descriptiveSplit));
    }

    private List<String> createHeaders(StatisticsToExport statistics) {
        List<String> base = this.createBaseHeaders();
        base.addAll(statistics.getNames());
        return base;
    }

    private List<String> createBaseHeaders() {
        ArrayList<String> headerNames = new ArrayList<String>();
        headerNames.add("inputName");
        headerNames.add("filePath");
        if (this.includeDescriptiveSplit) {
            for (int i = 0; i < this.maxSplitGroups; ++i) {
                headerNames.add(String.format("dscr%d", i));
            }
        }
        return headerNames;
    }

    private List<TypedValue> createValues(StatisticsToExport comparison, InputFromManager input, SplitString descriptiveSplit) throws OperationFailedException {
        List<TypedValue> base = this.createBaseValues(input, descriptiveSplit);
        base.addAll(comparison.getValues());
        return base;
    }

    private List<TypedValue> createBaseValues(InputFromManager input, SplitString descriptiveSplit) throws OperationFailedException {
        Elements rowElements = new Elements();
        try {
            rowElements.add(input.identifier());
            rowElements.add(input.pathForBindingRequired().toString());
        }
        catch (InputReadFailedException e) {
            throw new OperationFailedException((Throwable)e);
        }
        if (this.includeDescriptiveSplit) {
            for (int i = 0; i < this.maxSplitGroups; ++i) {
                rowElements.add(descriptiveSplit.getSplitPartOrEmptyString(i));
            }
        }
        return rowElements.getList();
    }

    public void end() {
        this.writer.ifPresent(CSVWriter::close);
    }

    private static class Elements {
        private List<TypedValue> delegate = new ArrayList<TypedValue>();

        private Elements() {
        }

        public void add(String text) {
            this.delegate.add(new TypedValue(text, false));
        }

        public List<TypedValue> getList() {
            return this.delegate;
        }
    }
}

