/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.annotation.bean.comparison;

import io.vavr.Tuple2;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.annotation.io.assignment.Assignment;
import org.anchoranalysis.annotation.io.assignment.generator.AssignmentColorPool;
import org.anchoranalysis.annotation.io.assignment.generator.AssignmentGenerator;
import org.anchoranalysis.annotation.io.assignment.generator.DrawColoredObjects;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.DefaultInstance;
import org.anchoranalysis.bean.shared.color.scheme.ColorScheme;
import org.anchoranalysis.bean.shared.color.scheme.VeryBright;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.OptionalUtilities;
import org.anchoranalysis.core.identifier.provider.NamedProviderGetException;
import org.anchoranalysis.core.identifier.provider.store.NamedProviderStore;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.JobExecutionException;
import org.anchoranalysis.experiment.bean.task.Task;
import org.anchoranalysis.experiment.task.InputBound;
import org.anchoranalysis.experiment.task.InputTypesExpected;
import org.anchoranalysis.experiment.task.ParametersExperiment;
import org.anchoranalysis.image.bean.displayer.StackDisplayer;
import org.anchoranalysis.image.core.stack.DisplayStack;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.core.stack.named.NamedStacks;
import org.anchoranalysis.image.io.stack.input.ProvidesStackInput;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.inference.concurrency.ConcurrencyPlan;
import org.anchoranalysis.io.input.InputFromManager;
import org.anchoranalysis.io.output.enabled.OutputEnabledMutable;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.io.output.outputter.Outputter;
import org.anchoranalysis.plugin.annotation.bean.comparison.CSVAssignment;
import org.anchoranalysis.plugin.annotation.bean.comparison.CSVComparisonGroup;
import org.anchoranalysis.plugin.annotation.bean.comparison.ComparisonSharedState;
import org.anchoranalysis.plugin.annotation.bean.comparison.ObjectsToCompareFactory;
import org.anchoranalysis.plugin.annotation.bean.comparison.SplitString;
import org.anchoranalysis.plugin.annotation.bean.comparison.assigner.AnnotationComparisonAssigner;
import org.anchoranalysis.plugin.annotation.comparison.AnnotationComparisonInput;
import org.anchoranalysis.plugin.annotation.comparison.ObjectsToCompare;
import org.anchoranalysis.plugin.annotation.counter.ImageCounter;

public class CompareAnnotations<T extends Assignment<ObjectMask>>
extends Task<AnnotationComparisonInput<ProvidesStackInput>, ComparisonSharedState<T>> {
    private static final String OUTPUT_BY_IMAGE = "byImage";
    public static final String OUTPUT_BY_GROUP = "byGroup";
    private static final String OUTPUT_OUTLINE = "outline";
    @BeanField
    private String background = "Image";
    @BeanField
    private String splitIdentifierRegex = "";
    @BeanField
    private int maxSplitGroups = 5;
    @BeanField
    private int numberLevelsGrouping = 0;
    @BeanField
    private boolean flatten = false;
    @BeanField
    private int outlineWidth = 1;
    @BeanField
    private AnnotationComparisonAssigner<T> assigner;
    @BeanField
    private boolean replaceMatchesWithSolids = true;
    @BeanField
    private ColorScheme colorsUnpaired = new VeryBright();
    @BeanField
    @DefaultInstance
    private StackDisplayer displayer;

    public ComparisonSharedState<T> beforeAnyJobIsExecuted(Outputter outputter, ConcurrencyPlan concurrencyPlan, List<AnnotationComparisonInput<ProvidesStackInput>> inputs, ParametersExperiment parameters) throws ExperimentExecutionException {
        try {
            CSVAssignment assignmentCSV = new CSVAssignment(outputter, OUTPUT_BY_IMAGE, this.hasDescriptiveSplit(), this.maxSplitGroups);
            return new ComparisonSharedState(assignmentCSV, this.numberLevelsGrouping, this.assigner::groupForKey);
        }
        catch (OutputWriteFailedException e) {
            throw new ExperimentExecutionException((Throwable)e);
        }
    }

    public void doJobOnInput(InputBound<AnnotationComparisonInput<ProvidesStackInput>, ComparisonSharedState<T>> input) throws JobExecutionException {
        SplitString descriptiveSplit;
        DisplayStack backgroundStack;
        AnnotationComparisonInput inputComparison = (AnnotationComparisonInput)((Object)input.getInput());
        Optional<Assignment<ObjectMask>> assignment = this.compareAndUpdate(inputComparison, backgroundStack = this.createBackground(inputComparison, input.getLogger()), descriptiveSplit = this.createSplitString(inputComparison), (InputOutputContext)input.getContextJob(), (ComparisonSharedState)input.getSharedState());
        if (assignment.isPresent()) {
            this.writeOutlineStack(input.getOutputter(), inputComparison, assignment.get(), backgroundStack);
        }
    }

    public InputTypesExpected inputTypesExpected() {
        return new InputTypesExpected(AnnotationComparisonInput.class);
    }

    public void afterAllJobsAreExecuted(ComparisonSharedState<T> sharedState, InputOutputContext context) throws ExperimentExecutionException {
        sharedState.getAssignmentCSV().end();
        try {
            new CSVComparisonGroup(sharedState.statisticsForAllGroups(), OUTPUT_BY_GROUP).writeGroupStats(context.getOutputter());
        }
        catch (OutputWriteFailedException e) {
            throw new ExperimentExecutionException((Throwable)e);
        }
    }

    public boolean hasVeryQuickPerInputExecution() {
        return false;
    }

    public OutputEnabledMutable defaultOutputs() {
        return super.defaultOutputs().addEnabledOutputFirst(new String[]{OUTPUT_BY_IMAGE, OUTPUT_BY_GROUP, OUTPUT_OUTLINE});
    }

    private Optional<Assignment<ObjectMask>> compareAndUpdate(AnnotationComparisonInput<ProvidesStackInput> input, DisplayStack background, SplitString descriptiveSplit, InputOutputContext context, ComparisonSharedState<T> sharedState) throws JobExecutionException {
        ImageCounter<T> addAnnotation = sharedState.groupsForImage(descriptiveSplit);
        Optional<ObjectsToCompare> objectsToCompare = ObjectsToCompareFactory.create(input, addAnnotation, background.dimensions(), context);
        return OptionalUtilities.map(objectsToCompare, objects -> this.processAcceptedAnnotation(input, background, (ObjectsToCompare)objects, addAnnotation, sharedState, descriptiveSplit, context));
    }

    private SplitString createSplitString(AnnotationComparisonInput<ProvidesStackInput> input) {
        return this.hasDescriptiveSplit() ? new SplitString(input.identifier(), this.splitIdentifierRegex) : null;
    }

    private DisplayStack createBackground(AnnotationComparisonInput<ProvidesStackInput> input, Logger logger) throws JobExecutionException {
        try {
            NamedStacks stacks = new NamedStacks();
            input.getInput().addToStoreInferNames((NamedProviderStore)stacks, logger);
            return this.displayer.deriveFrom((Stack)stacks.getException(this.background));
        }
        catch (CreateException | OperationFailedException e) {
            throw new JobExecutionException(e);
        }
        catch (NamedProviderGetException e) {
            throw new JobExecutionException(e.summarize());
        }
    }

    private Assignment<ObjectMask> processAcceptedAnnotation(AnnotationComparisonInput<ProvidesStackInput> input, DisplayStack background, ObjectsToCompare objectsToCompare, ImageCounter<T> counter, ComparisonSharedState<T> sharedState, SplitString descriptiveSplit, InputOutputContext context) throws JobExecutionException {
        context.getMessageReporter().log("Start processAcceptedAnnotation");
        try {
            T assignment = this.assigner.createAssignment(objectsToCompare, background.dimensions(), this.flatten, context);
            counter.addAnnotatedImage(assignment);
            sharedState.getAssignmentCSV().writeStatisticsForImage(assignment.statistics(), descriptiveSplit, (InputFromManager)input);
            return assignment;
        }
        catch (CreateException | OperationFailedException e) {
            throw new JobExecutionException(e);
        }
    }

    private boolean hasDescriptiveSplit() {
        return this.splitIdentifierRegex != null && !this.splitIdentifierRegex.isEmpty();
    }

    private void writeOutlineStack(Outputter outputter, AnnotationComparisonInput<ProvidesStackInput> input, Assignment<ObjectMask> assignment, DisplayStack background) {
        outputter.writerSelective().write(OUTPUT_OUTLINE, () -> this.createAssignmentGenerator(background, outputter.getSettings().getDefaultColors(), input.getNames()), () -> assignment);
    }

    private AssignmentGenerator createAssignmentGenerator(DisplayStack background, ColorScheme colorSchemeFromSettings, Tuple2<String, String> names) {
        DrawColoredObjects drawer = new DrawColoredObjects(background, this.flatten, this.outlineWidth);
        return new AssignmentGenerator(drawer, numberPaired -> this.createColorPool(numberPaired, colorSchemeFromSettings), names, this.assigner.moreThanOneObject());
    }

    private AssignmentColorPool createColorPool(int numberPaired, ColorScheme colorSchemeFromSettings) {
        return new AssignmentColorPool(numberPaired, colorSchemeFromSettings, this.colorsUnpaired, this.replaceMatchesWithSolids);
    }

    public String getBackground() {
        return this.background;
    }

    public void setBackground(String background) {
        this.background = background;
    }

    public String getSplitIdentifierRegex() {
        return this.splitIdentifierRegex;
    }

    public void setSplitIdentifierRegex(String splitIdentifierRegex) {
        this.splitIdentifierRegex = splitIdentifierRegex;
    }

    public int getMaxSplitGroups() {
        return this.maxSplitGroups;
    }

    public void setMaxSplitGroups(int maxSplitGroups) {
        this.maxSplitGroups = maxSplitGroups;
    }

    public int getNumberLevelsGrouping() {
        return this.numberLevelsGrouping;
    }

    public void setNumberLevelsGrouping(int numberLevelsGrouping) {
        this.numberLevelsGrouping = numberLevelsGrouping;
    }

    public boolean isFlatten() {
        return this.flatten;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public int getOutlineWidth() {
        return this.outlineWidth;
    }

    public void setOutlineWidth(int outlineWidth) {
        this.outlineWidth = outlineWidth;
    }

    public AnnotationComparisonAssigner<T> getAssigner() {
        return this.assigner;
    }

    public void setAssigner(AnnotationComparisonAssigner<T> assigner) {
        this.assigner = assigner;
    }

    public boolean isReplaceMatchesWithSolids() {
        return this.replaceMatchesWithSolids;
    }

    public void setReplaceMatchesWithSolids(boolean replaceMatchesWithSolids) {
        this.replaceMatchesWithSolids = replaceMatchesWithSolids;
    }

    public ColorScheme getColorsUnpaired() {
        return this.colorsUnpaired;
    }

    public void setColorsUnpaired(ColorScheme colorsUnpaired) {
        this.colorsUnpaired = colorsUnpaired;
    }

    public StackDisplayer getDisplayer() {
        return this.displayer;
    }

    public void setDisplayer(StackDisplayer displayer) {
        this.displayer = displayer;
    }
}

