/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.annotation.bean.comparison;

import java.util.Optional;
import org.anchoranalysis.annotation.io.image.findable.Findable;
import org.anchoranalysis.core.functional.OptionalUtilities;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.experiment.JobExecutionException;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.io.stack.input.ProvidesStackInput;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.io.input.InputReadFailedException;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.plugin.annotation.comparison.AnnotationComparisonInput;
import org.anchoranalysis.plugin.annotation.comparison.ObjectsToCompare;
import org.anchoranalysis.plugin.annotation.counter.ImageCounter;

class ObjectsToCompareFactory {
    public static Optional<ObjectsToCompare> create(AnnotationComparisonInput<ProvidesStackInput> input, ImageCounter<?> addAnnotation, Dimensions dimensions, InputOutputContext context) throws JobExecutionException {
        return OptionalUtilities.mapBoth(ObjectsToCompareFactory.createObjects(true, "leftObj", addAnnotation, input, dimensions, context), ObjectsToCompareFactory.createObjects(false, "rightObj", addAnnotation, input, dimensions, context), ObjectsToCompare::new);
    }

    private static Optional<ObjectCollection> createObjects(boolean left, String objName, ImageCounter<?> addAnnotation, AnnotationComparisonInput<ProvidesStackInput> input, Dimensions dimensions, InputOutputContext context) throws JobExecutionException {
        Findable<ObjectCollection> findable = ObjectsToCompareFactory.createFindable(left, input, dimensions, context.isDebugEnabled(), context.operationContext());
        return ObjectsToCompareFactory.foundOrLogAddUnnannotated(findable, objName, addAnnotation, context.getLogger());
    }

    private static Optional<ObjectCollection> foundOrLogAddUnnannotated(Findable<ObjectCollection> objects, String objName, ImageCounter<?> addAnnotation, Logger logger) {
        Optional found = objects.getOrLog(objName, logger);
        if (!found.isPresent()) {
            addAnnotation.addUnannotatedImage();
        }
        return found;
    }

    private static Findable<ObjectCollection> createFindable(boolean left, AnnotationComparisonInput<ProvidesStackInput> input, Dimensions dimensions, boolean debugMode, OperationContext context) throws JobExecutionException {
        try {
            return input.getComparerMultiplex(left).loadAsObjects(input.pathForBindingRequired(), dimensions, debugMode, context);
        }
        catch (InputReadFailedException e) {
            throw new JobExecutionException((Throwable)e);
        }
    }

    private ObjectsToCompareFactory() {
    }
}

