/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.annotation.bean.comparison.assigner;

import org.anchoranalysis.annotation.io.comparer.StatisticsToExport;
import org.anchoranalysis.plugin.annotation.counter.ImageCounterWithStatistics;

class GroupWithImageCount<T>
implements ImageCounterWithStatistics<T> {
    private final String identifier;
    private int countWithAnnotations = 0;
    private int countWithoutAnnotations = 0;

    @Override
    public void addUnannotatedImage() {
        ++this.countWithoutAnnotations;
    }

    @Override
    public void addAnnotatedImage(T payload) {
        ++this.countWithAnnotations;
    }

    public int numberImagesTotal() {
        return this.countWithAnnotations + this.countWithoutAnnotations;
    }

    public int numberImagesAnnotations() {
        return this.countWithAnnotations;
    }

    public double percentAnnotatedImages() {
        return (double)this.numberImagesAnnotations() * 100.0 / (double)this.numberImagesTotal();
    }

    @Override
    public StatisticsToExport comparison() {
        StatisticsToExport out = new StatisticsToExport();
        out.addString("name", this.identifier());
        out.addDouble("percentAnnotated", this.percentAnnotatedImages());
        out.addInt("countImages", this.numberImagesTotal());
        out.addInt("countImagesAnnotations", this.countWithAnnotations());
        out.addInt("countImagesWithoutAnnotations", this.countWithoutAnnotations());
        return out;
    }

    public GroupWithImageCount(String identifier) {
        this.identifier = identifier;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupWithImageCount)) {
            return false;
        }
        GroupWithImageCount other = (GroupWithImageCount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$identifier = this.identifier();
        String other$identifier = other.identifier();
        return !(this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GroupWithImageCount;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $identifier = this.identifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        return result;
    }

    public String identifier() {
        return this.identifier;
    }

    public int countWithAnnotations() {
        return this.countWithAnnotations;
    }

    public int countWithoutAnnotations() {
        return this.countWithoutAnnotations;
    }
}

