/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.annotation.bean.comparison;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import org.anchoranalysis.annotation.io.assignment.Assignment;
import org.anchoranalysis.annotation.io.comparer.StatisticsToExport;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.annotation.bean.comparison.CSVAssignment;
import org.anchoranalysis.plugin.annotation.bean.comparison.SplitString;
import org.anchoranalysis.plugin.annotation.counter.ImageCounter;
import org.anchoranalysis.plugin.annotation.counter.ImageCounterList;
import org.anchoranalysis.plugin.annotation.counter.ImageCounterWithStatistics;

public class ComparisonSharedState<T extends Assignment<ObjectMask>> {
    private CSVAssignment assignmentCSV;
    private ImageCounterWithStatistics<T> groupAll;
    private HashMap<String, ImageCounterWithStatistics<T>>[] groupsMap;
    private int numberLevelsGrouping;
    private Function<String, ImageCounterWithStatistics<T>> funcCreateGroup;

    public ComparisonSharedState(CSVAssignment assignmentCSV, int numberLevelsGrouping, Function<String, ImageCounterWithStatistics<T>> funcCreateGroup) {
        this.assignmentCSV = assignmentCSV;
        this.numberLevelsGrouping = numberLevelsGrouping;
        this.funcCreateGroup = funcCreateGroup;
        this.groupsMap = new HashMap[numberLevelsGrouping];
        for (int i = 0; i < numberLevelsGrouping; ++i) {
            this.groupsMap[i] = new HashMap();
        }
        this.groupAll = funcCreateGroup.apply("all");
    }

    public List<StatisticsToExport> statisticsForAllGroups() {
        ArrayList<StatisticsToExport> list = new ArrayList<StatisticsToExport>();
        list.add(this.groupAll.comparison());
        for (int i = 0; i < this.numberLevelsGrouping; ++i) {
            for (ImageCounterWithStatistics<T> counter : this.groupsMap[i].values()) {
                list.add(counter.comparison());
            }
        }
        return list;
    }

    private ImageCounterWithStatistics<T> getOrCreate(int level, String key) {
        ImageCounterWithStatistics<T> item = this.groupsMap[level].get(key);
        if (item == null) {
            item = this.funcCreateGroup.apply(key);
            this.groupsMap[level].put(key, item);
        }
        return item;
    }

    public ImageCounter<T> groupsForImage(SplitString descriptiveSplit) {
        ImageCounterList<T> list = new ImageCounterList<T>();
        list.add(this.groupAll);
        if (descriptiveSplit != null) {
            for (int i = 0; i < this.numberLevelsGrouping; ++i) {
                if (i >= descriptiveSplit.getNumParts()) continue;
                String groupName = descriptiveSplit.combineFirstElements(i + 1, "/");
                list.add(this.getOrCreate(i, groupName));
            }
        }
        return list;
    }

    @Generated
    public CSVAssignment getAssignmentCSV() {
        return this.assignmentCSV;
    }
}

