/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.annotation.bean.comparison.assigner;

import java.nio.file.Path;
import lombok.Generated;
import org.anchoranalysis.annotation.io.assignment.AssignOverlappingObjects;
import org.anchoranalysis.annotation.io.assignment.OverlappingObjects;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.initializable.parameters.BeanInitialization;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.initialization.FeatureRelatedInitialization;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.feature.bean.evaluator.FeatureEvaluator;
import org.anchoranalysis.image.feature.input.FeatureInputPairObjects;
import org.anchoranalysis.io.output.enabled.OutputEnabledMutable;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.plugin.annotation.bean.comparison.assigner.AnnotationComparisonAssigner;
import org.anchoranalysis.plugin.annotation.bean.comparison.assigner.FeatureCostGroup;
import org.anchoranalysis.plugin.annotation.bean.comparison.assigner.ObjectsCostMatrixGenerator;
import org.anchoranalysis.plugin.annotation.comparison.ObjectsToCompare;
import org.anchoranalysis.plugin.annotation.counter.ImageCounterWithStatistics;

public class FeatureCostAssigner
extends AnnotationComparisonAssigner<OverlappingObjects> {
    private static final String OUTPUT_COST_MATRIX = "costMatrix";
    @BeanField
    private FeatureEvaluator<FeatureInputPairObjects> featureEvaluator;
    @BeanField
    private double maxCost = 1.0;
    @BeanField
    private int numberDecimalPlaces = 3;
    @BeanField
    private boolean removeTouchingBorderXY = false;

    @Override
    public OverlappingObjects createAssignment(ObjectsToCompare objectsToCompare, Dimensions dimensions, boolean useMIP, InputOutputContext context) throws CreateException {
        try {
            FeatureRelatedInitialization soFeature = FeatureRelatedInitialization.create((Logger)context.getLogger(), (Path)context.getModelDirectory());
            this.featureEvaluator.initializeRecursive((BeanInitialization)soFeature, context.getLogger());
            AssignOverlappingObjects assignmentCreator = new AssignOverlappingObjects(this.featureEvaluator, useMIP);
            OverlappingObjects assignment = assignmentCreator.createAssignment(objectsToCompare.getLeft(), objectsToCompare.getRight(), this.maxCost, dimensions);
            if (this.removeTouchingBorderXY) {
                assignment.removeTouchingBorderXY(dimensions.extent());
            }
            context.getOutputter().writerSelective().write(OUTPUT_COST_MATRIX, () -> new ObjectsCostMatrixGenerator(this.numberDecimalPlaces), () -> ((AssignOverlappingObjects)assignmentCreator).getCosts());
            return assignment;
        }
        catch (InitializeException | FeatureCalculationException e) {
            throw new CreateException(e);
        }
    }

    @Override
    public ImageCounterWithStatistics<OverlappingObjects> groupForKey(String key) {
        return new FeatureCostGroup(key);
    }

    @Override
    public boolean moreThanOneObject() {
        return true;
    }

    @Override
    public void addDefaultOutputs(OutputEnabledMutable outputs) {
    }

    @Generated
    public FeatureEvaluator<FeatureInputPairObjects> getFeatureEvaluator() {
        return this.featureEvaluator;
    }

    @Generated
    public void setFeatureEvaluator(FeatureEvaluator<FeatureInputPairObjects> featureEvaluator) {
        this.featureEvaluator = featureEvaluator;
    }

    @Generated
    public double getMaxCost() {
        return this.maxCost;
    }

    @Generated
    public void setMaxCost(double maxCost) {
        this.maxCost = maxCost;
    }

    @Generated
    public int getNumberDecimalPlaces() {
        return this.numberDecimalPlaces;
    }

    @Generated
    public void setNumberDecimalPlaces(int numberDecimalPlaces) {
        this.numberDecimalPlaces = numberDecimalPlaces;
    }

    @Generated
    public boolean isRemoveTouchingBorderXY() {
        return this.removeTouchingBorderXY;
    }

    @Generated
    public void setRemoveTouchingBorderXY(boolean removeTouchingBorderXY) {
        this.removeTouchingBorderXY = removeTouchingBorderXY;
    }
}

