/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.annotation.bean.comparison.assigner;

import org.anchoranalysis.annotation.io.assignment.OverlappingObjects;
import org.anchoranalysis.annotation.io.comparer.StatisticsToExport;
import org.anchoranalysis.math.arithmetic.RunningSumExtrema;
import org.anchoranalysis.plugin.annotation.bean.comparison.assigner.GroupWithImageCount;
import org.anchoranalysis.plugin.annotation.counter.ImageCounterWithStatistics;

class FeatureCostGroup
implements ImageCounterWithStatistics<OverlappingObjects> {
    private int countMatched = 0;
    private int countUnmatchedLeft = 0;
    private int countUnmatchedRight = 0;
    private double sumOverlapRatio;
    private RunningSumExtrema percentLeftMatched = new RunningSumExtrema();
    private RunningSumExtrema percentRightMatched = new RunningSumExtrema();
    private GroupWithImageCount<OverlappingObjects> imageCount;

    public FeatureCostGroup(String identifier) {
        this.imageCount = new GroupWithImageCount(identifier);
    }

    @Override
    public void addAnnotatedImage(OverlappingObjects payload) {
        this.imageCount.addAnnotatedImage(payload);
        this.countMatched += payload.numberPaired();
        this.countUnmatchedLeft += payload.numberUnassigned(true);
        this.countUnmatchedRight += payload.numberUnassigned(false);
        this.sumOverlapRatio += payload.sumOverlapFromPaired();
        this.percentLeftMatched.add(payload.percentLeftAssigned());
        this.percentRightMatched.add(payload.percentRightAssigned());
    }

    @Override
    public StatisticsToExport comparison() {
        StatisticsToExport comparison = new StatisticsToExport();
        comparison.append(this.imageCount.comparison());
        comparison.addDouble("percentMatchesInAnnotation", this.percentLeftMatched());
        comparison.addDouble("percentMatchesInResult", this.percentRightMatched());
        comparison.addInt("matches", this.countMatched);
        comparison.addInt("unmatchedAnnotation", this.countUnmatchedLeft);
        comparison.addInt("numItemsInAnnotation", this.leftSize());
        comparison.addInt("unmatchedResult", this.countUnmatchedRight);
        comparison.addInt("numberItemsInResult", this.rightSize());
        comparison.addDouble("meanOverlapRatio", this.meanOverlapRatio());
        comparison.addMeanExtrema("percentAnnotationMatched", this.percentLeftMatched);
        comparison.addMeanExtrema("percentResultMatched", this.percentRightMatched);
        return comparison;
    }

    private double percentLeftMatched() {
        return (double)this.countMatched * 100.0 / (double)this.leftSize();
    }

    private double percentRightMatched() {
        return (double)this.countMatched * 100.0 / (double)this.rightSize();
    }

    private int leftSize() {
        return this.countMatched + this.countUnmatchedLeft;
    }

    private int rightSize() {
        return this.countMatched + this.countUnmatchedRight;
    }

    private double meanOverlapRatio() {
        return this.sumOverlapRatio / (double)this.countMatched;
    }

    @Override
    public void addUnannotatedImage() {
        this.imageCount.addUnannotatedImage();
    }
}

