/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.annotation.bean.comparison.assigner;

import org.anchoranalysis.annotation.io.assignment.ObjectVoxelIntersection;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.io.output.enabled.OutputEnabledMutable;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.plugin.annotation.bean.comparison.assigner.AnnotationComparisonAssigner;
import org.anchoranalysis.plugin.annotation.bean.comparison.assigner.GroupWithImageCount;
import org.anchoranalysis.plugin.annotation.comparison.ObjectsToCompare;
import org.anchoranalysis.plugin.annotation.counter.ImageCounterWithStatistics;

public class MaskIntersectionAssigner
extends AnnotationComparisonAssigner<ObjectVoxelIntersection> {
    @Override
    public ObjectVoxelIntersection createAssignment(ObjectsToCompare objectsToCompare, Dimensions dimensions, boolean useMIP, InputOutputContext context) throws CreateException {
        return new ObjectVoxelIntersection(MaskIntersectionAssigner.extractSingleObject("left", objectsToCompare.getLeft()), MaskIntersectionAssigner.extractSingleObject("right", objectsToCompare.getRight()));
    }

    @Override
    public ImageCounterWithStatistics<ObjectVoxelIntersection> groupForKey(String key) {
        return new GroupWithImageCount<ObjectVoxelIntersection>(key);
    }

    @Override
    public boolean moreThanOneObject() {
        return false;
    }

    @Override
    public void addDefaultOutputs(OutputEnabledMutable outputs) {
    }

    private static ObjectMask extractSingleObject(String description, ObjectCollection objects) throws CreateException {
        if (objects.size() == 0) {
            throw new CreateException(String.format("%s object-collection contains no objects. Exactly one must exist.", description));
        }
        if (objects.size() > 1) {
            throw new CreateException(String.format("%s object-collection contains %d objects. Only one is allowed.", description, objects.size()));
        }
        return objects.get(0);
    }
}

