/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.annotation.bean.comparison.assigner;

import java.nio.file.Path;
import java.util.List;
import org.anchoranalysis.annotation.io.assignment.CostMatrix;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.core.value.TypedValue;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.io.generator.tabular.CSVGenerator;
import org.anchoranalysis.io.generator.tabular.CSVWriter;
import org.anchoranalysis.io.output.bean.OutputWriteSettings;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;

class ObjectsCostMatrixGenerator
extends CSVGenerator<CostMatrix<ObjectMask>> {
    private final int numberDecimalPlaces;

    public ObjectsCostMatrixGenerator(int numberDecimalPlaces) {
        this.numberDecimalPlaces = numberDecimalPlaces;
    }

    public void writeToFile(CostMatrix<ObjectMask> element, OutputWriteSettings settings, Path filePath) throws OutputWriteFailedException {
        try (CSVWriter writer = CSVWriter.create((Path)filePath);){
            writer.writeHeaders(ObjectsCostMatrixGenerator.headers(element.getSecond()));
            List<String> descriptions = ObjectsCostMatrixGenerator.descriptionFromObjects(element.getFirst());
            for (int i = 0; i < element.sizeFirst(); ++i) {
                writer.writeRow(this.rowWithDescription(descriptions, i, element));
            }
        }
        catch (OutputWriteFailedException e) {
            throw new OutputWriteFailedException((Throwable)e);
        }
    }

    private List<TypedValue> rowWithDescription(List<String> descriptions, int index, CostMatrix<ObjectMask> element) {
        List<TypedValue> row = this.rowWithoutDescription(index, element);
        row.add(0, new TypedValue(descriptions.get(index)));
        return row;
    }

    private List<TypedValue> rowWithoutDescription(int index1, CostMatrix<ObjectMask> element) {
        return FunctionalList.mapRangeToList((int)0, (int)element.sizeSecond(), index2 -> new TypedValue(element.getCost(index1, index2), this.numberDecimalPlaces));
    }

    private static List<String> headers(List<ObjectMask> objects) {
        List<String> headers = ObjectsCostMatrixGenerator.descriptionFromObjects(objects);
        headers.add(0, "Objects");
        return headers;
    }

    private static List<String> descriptionFromObjects(List<ObjectMask> objects) {
        return FunctionalList.mapToList(objects, objectMask -> objectMask.centerOfGravity().toString());
    }
}

