/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.fiji.bean.channel.grayscalereconstruction;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.FloodFiller;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

class BinaryReconstruct_
implements PlugIn {
    BinaryReconstruct_() {
    }

    public void run(String arg) {
        Object[] result;
        if (IJ.versionLessThan((String)"1.37f")) {
            return;
        }
        int[] wList = WindowManager.getIDList();
        if (wList == null || wList.length < 2) {
            IJ.showMessage((String)"Binary Reconstruction", (String)"There must be at least two windows open");
            return;
        }
        String[] titles = new String[wList.length];
        int k = 0;
        for (int i = 0; i < wList.length; ++i) {
            ImagePlus imp = WindowManager.getImage((int)wList[i]);
            if (null == imp) continue;
            titles[k++] = imp.getTitle();
        }
        boolean createWindow = true;
        boolean whiteParticles = Prefs.blackBackground;
        boolean connect4 = false;
        GenericDialog gd = new GenericDialog("Binary Reconstruction");
        gd.addMessage("Binary Reconstruction v 2.2");
        gd.addChoice("mask :", titles, titles[0]);
        gd.addChoice("seed :", titles, titles[1]);
        gd.addCheckbox("Create New Window", createWindow);
        gd.addCheckbox("White particles on black background", whiteParticles);
        gd.addCheckbox("4 connected", false);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int i1Index = gd.getNextChoiceIndex();
        int i2Index = gd.getNextChoiceIndex();
        createWindow = gd.getNextBoolean();
        whiteParticles = gd.getNextBoolean();
        connect4 = gd.getNextBoolean();
        ImagePlus imp1 = WindowManager.getImage((int)wList[i1Index]);
        ImagePlus imp2 = WindowManager.getImage((int)wList[i2Index]);
        if (imp1.getStackSize() > 1 || imp2.getStackSize() > 1) {
            IJ.showMessage((String)"Error", (String)"Stacks not supported");
            return;
        }
        if (imp1.getBitDepth() != 8 || imp2.getBitDepth() != 8) {
            IJ.showMessage((String)"Error", (String)"Only 8-bit images are supported");
            return;
        }
        ImageStatistics stats = imp1.getStatistics();
        if (stats.histogram[0] + stats.histogram[255] != stats.pixelCount) {
            IJ.error((String)"8-bit binary mask image (0 and 255) required.");
            return;
        }
        stats = imp2.getStatistics();
        if (stats.histogram[0] + stats.histogram[255] != stats.pixelCount) {
            IJ.error((String)"8-bit binary seed image (0 and 255) required.");
            return;
        }
        String name = null;
        if (createWindow) {
            name = "Reconstructed";
        }
        if (null != (result = this.exec(imp1, imp2, name, createWindow, whiteParticles, connect4))) {
            ImagePlus resultImage = (ImagePlus)result[1];
            if (createWindow) {
                resultImage.show();
            } else {
                imp2.getProcessor().insert(resultImage.getProcessor(), 0, 0);
            }
        }
    }

    public Object[] exec(ImagePlus imp1, ImagePlus imp2, String new_name, boolean createWindow, boolean whiteParticles, boolean connect4) {
        int y;
        ImageProcessor ip3;
        ImagePlus imp3;
        if (null == imp1) {
            return null;
        }
        if (null == imp2) {
            return null;
        }
        if (null == new_name) {
            new_name = imp2.getTitle();
        }
        int width = imp1.getWidth();
        int height = imp1.getHeight();
        int size = width * height;
        int foreground = 255;
        int background = 0;
        int bf = -1;
        int bb = 0;
        int b127 = 127;
        IJ.showStatus((String)"Binary Reconstruction...");
        ImageProcessor ip1 = imp1.getProcessor();
        if (createWindow) {
            imp3 = new ImagePlus(new_name, imp2.getProcessor().duplicate());
            ip3 = imp3.getProcessor();
        } else {
            imp3 = imp2;
            ip3 = imp2.getProcessor();
        }
        if (!whiteParticles) {
            foreground = 0;
            background = 255;
            bf = 0;
            bb = -1;
        }
        byte[] pixel = (byte[])ip1.getPixels();
        byte[] seed = new byte[size];
        byte[] res = (byte[])ip3.getPixels();
        for (y = 0; y < size; ++y) {
            seed[y] = res[y];
            res[y] = (pixel[y] & 0xFF) == foreground ? b127 : bb;
        }
        FloodFiller ff = new FloodFiller(ip3);
        ip3.setColor(foreground);
        if (connect4) {
            for (y = 0; y < height; ++y) {
                offset = y * width;
                for (x = 0; x < width; ++x) {
                    pointer = offset + x;
                    if ((seed[pointer] & 0xFF) != foreground || (res[pointer] & 0xFF) != 127) continue;
                    ff.fill(x, y);
                }
            }
        } else {
            for (y = 0; y < height; ++y) {
                offset = y * width;
                for (x = 0; x < width; ++x) {
                    pointer = offset + x;
                    if ((seed[pointer] & 0xFF) != foreground || (res[pointer] & 0xFF) != 127) continue;
                    ff.fill8(x, y);
                }
            }
        }
        for (y = 0; y < size; ++y) {
            if ((res[y] & 0xFF) != 127) continue;
            res[y] = bb;
        }
        imp3.updateAndDraw();
        return new Object[]{new_name, imp3};
    }
}

