/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.fiji.bean.channel.grayscalereconstruction;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import org.anchoranalysis.plugin.fiji.bean.channel.grayscalereconstruction.BinaryReconstruct_;

class GreyscaleReconstruct_
implements PlugIn {
    GreyscaleReconstruct_() {
    }

    public void run(String arg) {
        if (IJ.versionLessThan((String)"1.37f")) {
            return;
        }
        int[] wList = WindowManager.getIDList();
        if (wList == null || wList.length < 2) {
            IJ.showMessage((String)"Greyscale Reconstruction", (String)"There must be at least two windows open");
            return;
        }
        String[] titles = new String[wList.length];
        int k = 0;
        for (int i = 0; i < wList.length; ++i) {
            ImagePlus imp = WindowManager.getImage((int)wList[i]);
            if (null == imp) continue;
            titles[k++] = imp.getTitle();
        }
        boolean createWindow = true;
        boolean connect4 = false;
        GenericDialog gd = new GenericDialog("Greyscale Reconstruction");
        gd.addMessage("Greyscale Reconstruction v 2.2");
        gd.addChoice("mask i1:", titles, titles[0]);
        gd.addChoice("seed i2:", titles, titles[1]);
        gd.addCheckbox("Create New Window", createWindow);
        gd.addCheckbox("4 connected", false);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int i1Index = gd.getNextChoiceIndex();
        int i2Index = gd.getNextChoiceIndex();
        createWindow = gd.getNextBoolean();
        connect4 = gd.getNextBoolean();
        ImagePlus imp1 = WindowManager.getImage((int)wList[i1Index]);
        ImagePlus imp2 = WindowManager.getImage((int)wList[i2Index]);
        if (imp1.getStackSize() > 1 || imp2.getStackSize() > 1) {
            IJ.showMessage((String)"Error", (String)"Stacks not supported");
            return;
        }
        if (imp1.getBitDepth() != 8 || imp2.getBitDepth() != 8) {
            IJ.showMessage((String)"Error", (String)"Only 8-bit images are supported");
            return;
        }
        String name = null;
        if (createWindow) {
            name = "Reconstructed";
        }
        long start = System.currentTimeMillis();
        Object[] result = this.exec(imp1, imp2, name, createWindow, connect4);
        if (null != result) {
            ImagePlus resultImage = (ImagePlus)result[1];
            if (createWindow) {
                resultImage.show();
            } else {
                imp2.setProcessor(imp2.getTitle(), resultImage.getProcessor());
            }
        }
        IJ.showStatus((String)(IJ.d2s((double)((double)(System.currentTimeMillis() - start) / 1000.0), (int)2) + " seconds"));
    }

    public Object[] exec(ImagePlus imp1, ImagePlus imp2, String new_name, boolean createWindow, boolean connect4) {
        int j;
        if (null == imp1) {
            return null;
        }
        if (null == imp2) {
            return null;
        }
        if (null == new_name) {
            new_name = imp2.getTitle();
        }
        int width = imp1.getWidth();
        int height = imp1.getHeight();
        int b_0 = 0;
        int b_255 = -1;
        IJ.showStatus((String)"Greyscale Reconstruction...");
        ImageProcessor ip1 = imp1.getProcessor();
        ImageProcessor ip2 = imp2.getProcessor();
        ImageStatistics stats = imp2.getStatistics();
        byte[] pixels1 = (byte[])ip1.getPixels();
        byte[] pixels2 = (byte[])ip2.getPixels();
        int size = pixels1.length;
        byte[] pixels3 = new byte[size];
        byte[] pixels4 = new byte[size];
        byte[] pixels5 = new byte[size];
        int[] intHisto = new int[256];
        intHisto[255] = stats.histogram[255];
        for (j = 254; j > -1; --j) {
            intHisto[j] = intHisto[j + 1] + stats.histogram[j];
        }
        for (j = 0; j < size; ++j) {
            pixels3[j] = b_0;
        }
        ByteProcessor ip3 = new ByteProcessor(width, height, pixels3, null);
        ImagePlus imp3 = new ImagePlus(new_name, (ImageProcessor)ip3);
        for (int i = 255; i > -1; --i) {
            if (intHisto[i] > 0) {
                System.arraycopy(pixels1, 0, pixels4, 0, size);
                System.arraycopy(pixels2, 0, pixels5, 0, size);
                for (j = 0; j < size; ++j) {
                    pixels4[j] = (pixels4[j] & 0xFF) < i ? b_0 : b_255;
                    pixels5[j] = (pixels5[j] & 0xFF) < i ? b_0 : b_255;
                }
                ByteProcessor ip4 = new ByteProcessor(width, height, pixels4, null);
                ImagePlus imp4 = new ImagePlus("_mask", (ImageProcessor)ip4);
                ByteProcessor ip5 = new ByteProcessor(width, height, pixels5, null);
                ImagePlus imp5 = new ImagePlus("_seed", (ImageProcessor)ip5);
                BinaryReconstruct_ br = new BinaryReconstruct_();
                Object[] result = br.exec(imp4, imp5, null, false, true, connect4);
                for (j = 0; j < size; ++j) {
                    if ((pixels5[j] & 0xFF) == 255) {
                        pixels5[j] = (byte)(i & 0xFF);
                    }
                    if ((pixels5[j] & 0xFF) <= (pixels3[j] & 0xFF)) continue;
                    pixels3[j] = pixels5[j];
                }
                imp4.close();
                imp5.close();
            }
            IJ.showProgress((double)((double)(255 - i) / 255.0));
        }
        imp3.updateAndDraw();
        return new Object[]{new_name, imp3};
    }
}

