/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.fiji.bean.channel.provider;

import lombok.Generated;
import net.imglib2.algorithm.pde.PeronaMalikAnisotropicDiffusion;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.RealType;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.Positive;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.functional.FunctionalIterate;
import org.anchoranalysis.image.bean.provider.ChannelProviderUnary;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.convert.imglib2.ConvertToImg;

public class AnisotropicDiffusion
extends ChannelProviderUnary {
    @BeanField
    @Positive
    private double kappa;
    @BeanField
    @Positive
    private double deltat;
    @BeanField
    private boolean do3D;
    @BeanField
    @Positive
    private int iterations = 30;
    @BeanField
    private boolean strongEdgeEnhancer = true;

    public Channel createFromChannel(Channel channel) throws ProvisionFailedException {
        return this.diffusion(channel, this.createDiffusionFunction());
    }

    private Channel diffusion(Channel channel, PeronaMalikAnisotropicDiffusion.DiffusionFunction diffusionFunction) throws ProvisionFailedException {
        try {
            if (this.do3D) {
                Img image = ConvertToImg.from((VoxelsUntyped)channel.voxels());
                this.doDiffusion(image, diffusionFunction);
            } else {
                channel.extent().iterateOverZ(z -> {
                    Img image = ConvertToImg.fromSlice((VoxelsUntyped)channel.voxels(), (int)z);
                    this.doDiffusion(image, diffusionFunction);
                });
            }
            return channel;
        }
        catch (IncompatibleTypeException e1) {
            throw new ProvisionFailedException((Throwable)e1);
        }
    }

    private <T extends RealType<T>> void doDiffusion(Img<T> image, PeronaMalikAnisotropicDiffusion.DiffusionFunction diffusionFunction) {
        FunctionalIterate.repeat((int)this.iterations, () -> PeronaMalikAnisotropicDiffusion.inFloatInPlace((Img)image, (double)this.deltat, (PeronaMalikAnisotropicDiffusion.DiffusionFunction)diffusionFunction));
    }

    private PeronaMalikAnisotropicDiffusion.DiffusionFunction createDiffusionFunction() {
        if (this.strongEdgeEnhancer) {
            return new PeronaMalikAnisotropicDiffusion.StrongEdgeEnhancer(this.kappa);
        }
        return new PeronaMalikAnisotropicDiffusion.WideRegionEnhancer(this.kappa);
    }

    @Generated
    public double getKappa() {
        return this.kappa;
    }

    @Generated
    public void setKappa(double kappa) {
        this.kappa = kappa;
    }

    @Generated
    public double getDeltat() {
        return this.deltat;
    }

    @Generated
    public void setDeltat(double deltat) {
        this.deltat = deltat;
    }

    @Generated
    public boolean isDo3D() {
        return this.do3D;
    }

    @Generated
    public void setDo3D(boolean do3D) {
        this.do3D = do3D;
    }

    @Generated
    public int getIterations() {
        return this.iterations;
    }

    @Generated
    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    @Generated
    public boolean isStrongEdgeEnhancer() {
        return this.strongEdgeEnhancer;
    }

    @Generated
    public void setStrongEdgeEnhancer(boolean strongEdgeEnhancer) {
        this.strongEdgeEnhancer = strongEdgeEnhancer;
    }
}

