/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.fiji.bean.channel.provider.distance;

import java.util.Optional;
import java.util.function.ToDoubleFunction;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.channel.convert.ConversionPolicy;
import org.anchoranalysis.image.core.channel.convert.ToUnsignedByte;
import org.anchoranalysis.image.core.channel.convert.ToUnsignedShort;
import org.anchoranalysis.image.core.channel.factory.ChannelFactory;
import org.anchoranalysis.image.core.channel.factory.ChannelFactorySingleType;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.dimensions.Resolution;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.datatype.FloatVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedShortVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.plugin.fiji.bean.channel.provider.distance.EDT;
import org.anchoranalysis.plugin.image.bean.channel.provider.mask.FromMaskBase;

public class DistanceTransform3D
extends FromMaskBase {
    @BeanField
    private boolean suppressZ = false;
    @BeanField
    private float multiplyBy = 1.0f;
    @BeanField
    private boolean createShort = false;
    @BeanField
    private boolean applyResolution = false;
    @BeanField
    private boolean ignoreZIfNaN = true;

    protected Channel createFromMask(Mask mask) throws ProvisionFailedException {
        return this.createDistanceMapForMask(mask, 1.0f);
    }

    public Voxels<UnsignedByteBuffer> createDistanceMapForVoxels(BinaryVoxels<UnsignedByteBuffer> voxels, Optional<Resolution> resolution, float multiplyByZRes) throws ProvisionFailedException {
        Channel channel = ((ChannelFactorySingleType)ChannelFactory.instance().get((VoxelDataType)UnsignedByteVoxelType.INSTANCE)).create(voxels.voxels(), resolution);
        Mask mask = new Mask(channel, voxels.binaryValues());
        Channel distanceMap = this.createDistanceMapForMask(mask, multiplyByZRes);
        return distanceMap.voxels().asByte();
    }

    private Channel createDistanceMapForMask(Mask mask, float multiplyByZRes) throws ProvisionFailedException {
        boolean excludeZDimension;
        if (mask.binaryValuesInt().getOn() != 255) {
            throw new ProvisionFailedException("Binary On must be 255");
        }
        if (mask.binaryValuesInt().getOff() != 0) {
            throw new ProvisionFailedException("Binary Off must be 0");
        }
        if (mask.resolution().isPresent() && mask.extent().z() > 1 && !this.suppressZ) {
            this.checkZResolution((Resolution)mask.resolution().get());
        }
        boolean bl = excludeZDimension = this.suppressZ || DistanceTransform3D.hasNanZResolution(mask.resolution());
        if (excludeZDimension) {
            Channel channelOut = DistanceTransform3D.createEmptyChannel(this.createShort, mask.dimensions());
            for (int z = 0; z < mask.dimensions().extent().z(); ++z) {
                Mask slice = mask.extractSlice(z);
                Channel distanceSlice = DistanceTransform3D.createDistanceMapFromPlugin(slice, true, this.multiplyBy, multiplyByZRes, this.createShort, this.applyResolution);
                channelOut.voxels().replaceSlice(z, distanceSlice.voxels(), 0, true);
            }
            return channelOut;
        }
        return DistanceTransform3D.createDistanceMapFromPlugin(mask, false, this.multiplyBy, multiplyByZRes, this.createShort, this.applyResolution);
    }

    private static boolean hasNanZResolution(Optional<Resolution> resolution) {
        if (resolution.isPresent()) {
            return Double.isNaN(resolution.get().z());
        }
        return false;
    }

    private static Channel createEmptyChannel(boolean createShort, Dimensions dims) {
        UnsignedShortVoxelType dataType = createShort ? UnsignedShortVoxelType.INSTANCE : UnsignedByteVoxelType.INSTANCE;
        return ChannelFactory.instance().createUninitialised(dims, (VoxelDataType)dataType);
    }

    private static Channel createDistanceMapFromPlugin(Mask mask, boolean suppressZ, float multFactor, float multFactorZ, boolean createShort, boolean applyResolution) {
        float[] multipliers = new float[]{DistanceTransform3D.multiplicationFactor(multFactor, applyResolution, mask, Resolution::x), DistanceTransform3D.multiplicationFactor(multFactor, applyResolution, mask, Resolution::y), DistanceTransform3D.multiplicationFactor(multFactorZ, applyResolution, mask, Resolution::z)};
        Channel distanceAsFloat = EDT.compute(mask, (ChannelFactorySingleType)ChannelFactory.instance().get((VoxelDataType)FloatVoxelType.INSTANCE), suppressZ, multipliers);
        ToUnsignedShort converter = createShort ? new ToUnsignedShort() : new ToUnsignedByte();
        return converter.convert(distanceAsFloat, ConversionPolicy.CHANGE_EXISTING_CHANNEL);
    }

    private void checkZResolution(Resolution resolution) throws ProvisionFailedException {
        double zRelRes = resolution.zRelative();
        if (!this.ignoreZIfNaN && Double.isNaN(zRelRes)) {
            throw new ProvisionFailedException("Z-resolution is NaN");
        }
        if (zRelRes == 0.0) {
            throw new ProvisionFailedException("Z-resolution is 0");
        }
    }

    private static float multiplicationFactor(float multFactor, boolean applyResolution, Mask mask, ToDoubleFunction<Resolution> extractFromResolution) {
        if (applyResolution && mask.resolution().isPresent()) {
            return (float)((double)multFactor * extractFromResolution.applyAsDouble((Resolution)mask.resolution().get()));
        }
        return multFactor;
    }

    @Generated
    public boolean isSuppressZ() {
        return this.suppressZ;
    }

    @Generated
    public void setSuppressZ(boolean suppressZ) {
        this.suppressZ = suppressZ;
    }

    @Generated
    public float getMultiplyBy() {
        return this.multiplyBy;
    }

    @Generated
    public void setMultiplyBy(float multiplyBy) {
        this.multiplyBy = multiplyBy;
    }

    @Generated
    public boolean isCreateShort() {
        return this.createShort;
    }

    @Generated
    public void setCreateShort(boolean createShort) {
        this.createShort = createShort;
    }

    @Generated
    public boolean isApplyResolution() {
        return this.applyResolution;
    }

    @Generated
    public void setApplyResolution(boolean applyResolution) {
        this.applyResolution = applyResolution;
    }

    @Generated
    public boolean isIgnoreZIfNaN() {
        return this.ignoreZIfNaN;
    }

    @Generated
    public void setIgnoreZIfNaN(boolean ignoreZIfNaN) {
        this.ignoreZIfNaN = ignoreZIfNaN;
    }
}

