/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.fiji.bean.channel.provider.distance;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.image.bean.provider.ObjectCollectionProvider;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.channel.factory.ChannelFactory;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.dimensions.Resolution;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.fiji.bean.channel.provider.distance.DistanceTransform3D;
import org.anchoranalysis.plugin.image.bean.channel.provider.FromDimensionsBase;

public class DistanceTransformForEachObject3D
extends FromDimensionsBase {
    @BeanField
    private ObjectCollectionProvider objects;
    @BeanField
    private boolean suppressZ = false;
    @BeanField
    private boolean createShort = false;

    protected Channel createFromDimensions(Dimensions dimensions) throws ProvisionFailedException {
        Channel out = ChannelFactory.instance().create(dimensions, (VoxelDataType)UnsignedByteVoxelType.INSTANCE);
        Voxels voxelsOut = out.voxels().asByte();
        for (ObjectMask object : (ObjectCollection)this.objects.get()) {
            this.copyObjectToOutput(object, dimensions.resolution(), (Voxels<UnsignedByteBuffer>)voxelsOut);
        }
        return out;
    }

    private void copyObjectToOutput(ObjectMask object, Optional<Resolution> resolution, Voxels<UnsignedByteBuffer> destination) throws ProvisionFailedException {
        Voxels<UnsignedByteBuffer> voxelsDistance = this.distanceTransformForObject(object, resolution);
        ObjectMask objectAtOrigin = object.shiftToOrigin();
        voxelsDistance.extract().objectCopyTo(objectAtOrigin, destination, object.boundingBox());
    }

    private Voxels<UnsignedByteBuffer> distanceTransformForObject(ObjectMask object, Optional<Resolution> resolution) throws ProvisionFailedException {
        DistanceTransform3D transform = new DistanceTransform3D();
        transform.setSuppressZ(this.suppressZ);
        transform.setCreateShort(this.createShort);
        return transform.createDistanceMapForVoxels((BinaryVoxels<UnsignedByteBuffer>)object.binaryVoxels().duplicate(), resolution, 1.0f);
    }

    @Generated
    public ObjectCollectionProvider getObjects() {
        return this.objects;
    }

    @Generated
    public void setObjects(ObjectCollectionProvider objects) {
        this.objects = objects;
    }

    @Generated
    public boolean isSuppressZ() {
        return this.suppressZ;
    }

    @Generated
    public void setSuppressZ(boolean suppressZ) {
        this.suppressZ = suppressZ;
    }

    @Generated
    public boolean isCreateShort() {
        return this.createShort;
    }

    @Generated
    public void setCreateShort(boolean createShort) {
        this.createShort = createShort;
    }
}

