/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.fiji.bean.channel.provider.distance;

import java.nio.FloatBuffer;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.plugin.fiji.bean.channel.provider.distance.EDTDimensionBase;
import org.anchoranalysis.spatial.box.Extent;

abstract class EDTOneDimension
extends EDTDimensionBase {
    private Voxels<FloatBuffer> stack;
    private FloatBuffer slice;
    private int offset;
    private int lastOffset;
    private int rowStride;
    private int columnStride;
    private int sliceIndex;

    protected EDTOneDimension(Voxels<FloatBuffer> out, boolean iterateX) {
        super(iterateX ? out.extent().x() : out.extent().y());
        this.stack = out;
        Extent extent = out.extent();
        this.columnStride = iterateX ? 1 : extent.x();
        this.rowStride = iterateX ? extent.x() : 1;
        this.offset = extent.areaXY();
        this.lastOffset = this.rowStride * (iterateX ? extent.y() : extent.x());
        this.sliceIndex = -1;
    }

    @Override
    protected final float get(int x) {
        return this.slice.get(x * this.columnStride + this.offset);
    }

    @Override
    protected final boolean nextRow() {
        this.offset += this.rowStride;
        if (this.offset >= this.lastOffset) {
            if (++this.sliceIndex >= this.stack.extent().z()) {
                return false;
            }
            this.offset = 0;
            this.slice = (FloatBuffer)this.stack.sliceBuffer(this.sliceIndex);
        }
        return true;
    }

    protected void putIntoBuffer(int x, float value) {
        this.slice.put(x * this.columnStride + this.offset, value);
    }
}

