/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.fiji.bean.mask.provider;

import fiji.threshold.Auto_Local_Threshold;
import ij.ImagePlus;
import ij.process.ImageProcessor;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.core.mask.MaskFactory;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesInt;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.io.imagej.convert.ConvertToImagePlus;
import org.anchoranalysis.io.imagej.convert.ConvertToVoxelBuffer;
import org.anchoranalysis.io.imagej.convert.ImageJConversionException;
import org.anchoranalysis.plugin.image.bean.mask.provider.FromChannelBase;

public class AutoLocalThreshold
extends FromChannelBase {
    @BeanField
    private String method = "";
    @BeanField
    private int radius = 15;

    protected Mask createFromSource(Channel channel) throws CreateException {
        channel = channel.duplicate();
        Stack stack = new Stack(channel);
        Mask out = MaskFactory.createMaskOff((Dimensions)channel.dimensions(), (BinaryValuesInt)BinaryValuesInt.getDefault());
        Auto_Local_Threshold at = new Auto_Local_Threshold();
        channel.extent().iterateOverZ(z -> {
            VoxelBuffer<UnsignedByteBuffer> thresholded = this.thresholdSlice(stack.extractSlice(z), at);
            out.voxels().replaceSlice(z, thresholded);
        });
        return out;
    }

    private VoxelBuffer<UnsignedByteBuffer> thresholdSlice(Stack slice, Auto_Local_Threshold at) throws CreateException {
        try {
            ImagePlus imagePlus = ConvertToImagePlus.from((Stack)slice, (boolean)false);
            Object[] ret = at.exec(imagePlus, this.method, this.radius, 0.0, 0.0, true);
            ImagePlus imageOut = (ImagePlus)ret[0];
            ImageProcessor processor = imageOut.getImageStack().getProcessor(1);
            return ConvertToVoxelBuffer.asByte((ImageProcessor)processor);
        }
        catch (ImageJConversionException e) {
            throw new CreateException((Throwable)e);
        }
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public void setMethod(String method) {
        this.method = method;
    }

    @Generated
    public int getRadius() {
        return this.radius;
    }

    @Generated
    public void setRadius(int radius) {
        this.radius = radius;
    }
}

