/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.fiji.bean.threshold;

import fiji.threshold.Auto_Threshold;
import ij.ImagePlus;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.threshold.Thresholder;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxelsFactory;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesInt;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.io.imagej.convert.ConvertFromImagePlus;
import org.anchoranalysis.io.imagej.convert.ConvertToImagePlus;
import org.anchoranalysis.io.imagej.convert.ImageJConversionException;
import org.anchoranalysis.math.histogram.Histogram;

public class ThresholderAutoIJ
extends Thresholder {
    @BeanField
    private String method = "";
    @BeanField
    private boolean noBlack = false;

    public BinaryVoxels<UnsignedByteBuffer> threshold(VoxelsUntyped inputBuffer, BinaryValuesByte binaryValues, Optional<Histogram> histogram, Optional<ObjectMask> objectMask) throws OperationFailedException {
        if (objectMask.isPresent()) {
            throw new OperationFailedException("A mask is not supported for this operation");
        }
        try {
            ImagePlus image = ConvertToImagePlus.from((VoxelsUntyped)inputBuffer);
            this.applyThreshold(image);
            return ThresholderAutoIJ.convertToBinary(image, binaryValues);
        }
        catch (ImageJConversionException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private void applyThreshold(ImagePlus image) {
        Auto_Threshold at = new Auto_Threshold();
        at.exec(image, this.method, false, this.noBlack, true, false, false, true);
    }

    private static BinaryVoxels<UnsignedByteBuffer> convertToBinary(ImagePlus image, BinaryValuesByte binaryValues) throws OperationFailedException {
        VoxelsUntyped thresholdedVoxels = ConvertFromImagePlus.toVoxels((ImagePlus)image);
        if (!thresholdedVoxels.getVoxelDataType().equals((Object)UnsignedByteVoxelType.INSTANCE)) {
            throw new OperationFailedException("The threshold operation returned a data-type that is not unsigned 8-bit");
        }
        return BinaryVoxelsFactory.reuseByte((Voxels)thresholdedVoxels.asByte(), (BinaryValuesInt)binaryValues.asInt());
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public void setMethod(String method) {
        this.method = method;
    }

    @Generated
    public boolean isNoBlack() {
        return this.noBlack;
    }

    @Generated
    public void setNoBlack(boolean noBlack) {
        this.noBlack = noBlack;
    }
}

