/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.fiji.bean.channel.grayscalereconstruction;

import ij.ImagePlus;
import java.util.Optional;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.io.imagej.convert.ConvertFromImagePlus;
import org.anchoranalysis.io.imagej.convert.ConvertToImagePlus;
import org.anchoranalysis.plugin.fiji.bean.channel.grayscalereconstruction.GreyscaleReconstruct_;
import org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.minima.grayscalereconstruction.GrayscaleReconstructionByErosion;

public class GrayscaleReconstruction2DIJ
extends GrayscaleReconstructionByErosion {
    public VoxelsUntyped reconstruction(VoxelsUntyped mask, VoxelsUntyped marker, Optional<ObjectMask> containingMask) throws OperationFailedException {
        if (containingMask.isPresent()) {
            throw new OperationFailedException("A mask is not supported for this operation");
        }
        if (!marker.getVoxelDataType().equals((Object)UnsignedByteVoxelType.INSTANCE) || !mask.getVoxelDataType().equals((Object)UnsignedByteVoxelType.INSTANCE)) {
            throw new OperationFailedException("Only unsigned byte supported for marker image");
        }
        Voxels markerCast = marker.asByte();
        Voxels maskCast = mask.asByte();
        markerCast.arithmetic().subtractFrom(255);
        mask.subtractFromMaxValue();
        Voxels<UnsignedByteBuffer> ret = this.reconstructionByDilation((Voxels<UnsignedByteBuffer>)maskCast, (Voxels<UnsignedByteBuffer>)markerCast);
        ret.arithmetic().subtractFrom(255);
        return new VoxelsUntyped(ret);
    }

    private Voxels<UnsignedByteBuffer> reconstructionByDilation(Voxels<UnsignedByteBuffer> mask, Voxels<UnsignedByteBuffer> marker) {
        ImagePlus imageMask = ConvertToImagePlus.fromSlice(mask, (int)0, (String)"mask");
        ImagePlus imageMarker = ConvertToImagePlus.fromSlice(marker, (int)0, (String)"marker");
        GreyscaleReconstruct_ gr = new GreyscaleReconstruct_();
        Object[] ret = gr.exec(imageMask, imageMarker, "recon", true, false);
        ImagePlus ipRecon = (ImagePlus)ret[1];
        return ConvertFromImagePlus.toVoxels((ImagePlus)ipRecon).asByte();
    }
}

