/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.fiji.bean.channel.provider.distance;

import java.nio.FloatBuffer;
import lombok.Generated;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.plugin.fiji.bean.channel.provider.distance.EDTDimensionBase;

class EDTDimensionZ
extends EDTDimensionBase {
    private byte[][] inSlice;
    private float[][] outSlice;
    private int offset;
    private int bufferXYSize;
    private float multiplyConstant;

    public EDTDimensionZ(Voxels<UnsignedByteBuffer> in, Voxels<FloatBuffer> out, float multiplyConstant) {
        super(in.extent().z());
        this.multiplyConstant = multiplyConstant;
        int sizeZ = in.extent().z();
        this.bufferXYSize = in.extent().areaXY();
        this.inSlice = new byte[sizeZ][];
        this.outSlice = new float[sizeZ][];
        for (int i = 0; i < sizeZ; ++i) {
            this.inSlice[i] = ((UnsignedByteBuffer)in.sliceBuffer(i)).array();
            this.outSlice[i] = ((FloatBuffer)out.sliceBuffer(i)).array();
        }
        this.offset = -1;
    }

    @Override
    public final float get(int x) {
        return this.inSlice[x][this.offset] == 0 ? 0.0f : Float.MAX_VALUE;
    }

    @Override
    public final void set(int x, float value) {
        this.outSlice[x][this.offset] = value;
    }

    @Override
    public final boolean nextRow() {
        return ++this.offset < this.bufferXYSize;
    }

    @Override
    @Generated
    public float getMultiplyConstant() {
        return this.multiplyConstant;
    }
}

