/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.list.pair;

import org.anchoranalysis.bean.annotation.AllowEmpty;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.bean.list.FeatureListProvider;
import org.anchoranalysis.feature.name.AssignFeatureNameUtilities;
import org.anchoranalysis.image.feature.bean.object.pair.FeatureDeriveFromPair;
import org.anchoranalysis.image.feature.bean.object.pair.First;
import org.anchoranalysis.image.feature.bean.object.pair.Merged;
import org.anchoranalysis.image.feature.bean.object.pair.Second;
import org.anchoranalysis.image.feature.input.FeatureInputPairObjects;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;

public class DeriveFromPair
extends FeatureListProvider<FeatureInputPairObjects> {
    @BeanField
    private FeatureListProvider<FeatureInputSingleObject> item;
    @BeanField
    @AllowEmpty
    private String prefix = "";
    @BeanField
    private String select;

    public FeatureList<FeatureInputPairObjects> get() throws ProvisionFailedException {
        return ((FeatureList)this.item.get()).map(this::pairFromSingle);
    }

    private FeatureDeriveFromPair pairFromSingle(Feature<FeatureInputSingleObject> existing) throws ProvisionFailedException {
        Feature existingDuplicated = (Feature)existing.duplicateBean();
        FeatureDeriveFromPair featDelegate = this.createNewDelegateFeature();
        featDelegate.setItem(existingDuplicated);
        AssignFeatureNameUtilities.assignWithPrefix((Feature)featDelegate, (String)existingDuplicated.getFriendlyName(), (String)this.prefix);
        return featDelegate;
    }

    private FeatureDeriveFromPair createNewDelegateFeature() throws ProvisionFailedException {
        if (this.select.equalsIgnoreCase("first")) {
            return new First();
        }
        if (this.select.equalsIgnoreCase("second")) {
            return new Second();
        }
        if (this.select.equalsIgnoreCase("merged")) {
            return new Merged();
        }
        throw new ProvisionFailedException("An invalid input existings for 'select'. Select one of 'first', 'second' or 'merged'");
    }

    public FeatureListProvider<FeatureInputSingleObject> getItem() {
        return this.item;
    }

    public void setItem(FeatureListProvider<FeatureInputSingleObject> item) {
        this.item = item;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSelect() {
        return this.select;
    }

    public void setSelect(String select) {
        this.select = select;
    }
}

