/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.list.permute;

import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.permute.property.PermutePropertySequenceInteger;
import org.anchoranalysis.bean.primitive.StringSet;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.input.FeatureInputDictionary;
import org.anchoranalysis.plugin.image.feature.bean.list.permute.PermuteFeature;
import org.anchoranalysis.plugin.image.feature.bean.list.permute.PermuteFeatureSequenceInteger;
import org.anchoranalysis.plugin.operator.feature.bean.arithmetic.MultiplyByConstant;
import org.anchoranalysis.plugin.operator.feature.bean.range.IfOutsideRange;
import org.anchoranalysis.plugin.operator.feature.bean.statistics.StatisticalBase;

public abstract class PermuteFirstSecondOrder<T extends FeatureInputDictionary>
extends PermuteFeatureSequenceInteger<T> {
    @BeanField
    private boolean paramPrefixAppendNumber = true;
    private final CreateFirstSecondOrder<T> factory;
    private final double minRange;
    private final double maxRange;

    @Override
    protected PermuteFeature<Integer, T> createDelegate(Feature<T> feature) throws ProvisionFailedException {
        PermuteFeature delegate = new PermuteFeature();
        Feature<T> featureScore = (Feature<T>)feature.duplicateBean();
        featureScore = this.wrapInScore(featureScore);
        featureScore = this.wrapWithMultiplyByConstant(featureScore);
        featureScore = this.wrapWithMinMaxRange(featureScore);
        delegate.setFeature(featureScore);
        return delegate;
    }

    private Feature<T> wrapWithMultiplyByConstant(Feature<T> feature) {
        MultiplyByConstant out = new MultiplyByConstant();
        out.setItem(feature);
        out.setValue(1.0);
        return out;
    }

    private Feature<T> wrapWithMinMaxRange(Feature<T> feature) {
        IfOutsideRange out = new IfOutsideRange();
        out.setItem(feature);
        out.setMin(this.minRange);
        out.setMax(this.maxRange);
        out.setBelowMinValue(this.minRange);
        out.setAboveMaxValue(this.maxRange);
        return out;
    }

    private Feature<T> wrapInScore(Feature<T> feature) {
        StatisticalBase<T> featureScore = this.factory.create();
        featureScore.setItem(feature);
        featureScore.setItemMean(this.createParam("_fitted_normal_mean", this.paramPrefixAppendNumber));
        featureScore.setItemStdDev(this.createParam("_fitted_normal_sd", this.paramPrefixAppendNumber));
        return featureScore;
    }

    @Override
    protected PermutePropertySequenceInteger configurePermuteProperty(PermutePropertySequenceInteger permuteProperty) {
        if (permuteProperty.getAdditionalPropertyPaths() == null) {
            permuteProperty.setAdditionalPropertyPaths(new StringSet());
        }
        if (this.paramPrefixAppendNumber) {
            permuteProperty.getAdditionalPropertyPaths().add("item.item.itemMean.key");
            permuteProperty.getAdditionalPropertyPaths().add("item.item.itemStdDev.key");
        }
        permuteProperty.setPropertyPath(String.format("item.item.item.%s", permuteProperty.getPropertyPath()));
        return permuteProperty;
    }

    public PermuteFirstSecondOrder(CreateFirstSecondOrder<T> factory, double minRange, double maxRange) {
        this.factory = factory;
        this.minRange = minRange;
        this.maxRange = maxRange;
    }

    public boolean isParamPrefixAppendNumber() {
        return this.paramPrefixAppendNumber;
    }

    public void setParamPrefixAppendNumber(boolean paramPrefixAppendNumber) {
        this.paramPrefixAppendNumber = paramPrefixAppendNumber;
    }

    @FunctionalInterface
    public static interface CreateFirstSecondOrder<T extends FeatureInput> {
        public StatisticalBase<T> create();
    }
}

