/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.combine;

import java.util.List;
import java.util.Optional;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.BeanInstanceMap;
import org.anchoranalysis.bean.NamedBean;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.DefaultInstance;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.exception.friendly.HasFriendlyErrorMessage;
import org.anchoranalysis.core.functional.StreamableCollection;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.feature.bean.list.FeatureListProvider;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.store.NamedFeatureStoreFactory;
import org.anchoranalysis.image.bean.interpolator.Interpolator;
import org.anchoranalysis.image.feature.calculator.FeatureTableCalculator;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.plugin.image.bean.thumbnail.object.OutlinePreserveRelativeSize;
import org.anchoranalysis.plugin.image.bean.thumbnail.object.ThumbnailFromObjects;
import org.anchoranalysis.plugin.image.feature.object.ListWithThumbnails;
import org.anchoranalysis.spatial.box.BoundingBox;

public abstract class CombineObjectsForFeatures<T extends FeatureInput>
extends AnchorBean<CombineObjectsForFeatures<T>> {
    @BeanField
    @OptionalBean
    private ThumbnailFromObjects thumbnail;
    @BeanField
    @DefaultInstance
    private Interpolator interpolator;
    private BeanInstanceMap defaultInstances;

    public void checkMisconfigured(BeanInstanceMap defaultInstances) throws BeanMisconfiguredException {
        super.checkMisconfigured(defaultInstances);
        this.defaultInstances = defaultInstances;
    }

    protected CombineObjectsForFeatures(Interpolator interpolator) {
        this.interpolator = interpolator;
    }

    public abstract FeatureTableCalculator<T> createFeatures(List<NamedBean<FeatureListProvider<FeatureInputSingleObject>>> var1, NamedFeatureStoreFactory var2, boolean var3) throws CreateException, InitializeException;

    public abstract String uniqueIdentifierFor(T var1);

    public ListWithThumbnails<T, ObjectCollection> deriveInputsStartBatch(ObjectCollection objects, EnergyStack energyStack, boolean thumbnailsEnabled, OperationContext context) throws CreateException {
        List<T> inputs = this.startBatchDeriveInputs(objects, energyStack, context.getLogger());
        if (inputs.isEmpty()) {
            return new ListWithThumbnails(inputs);
        }
        if (thumbnailsEnabled) {
            if (this.thumbnail == null) {
                this.thumbnail = OutlinePreserveRelativeSize.createToColorUnselectedObjects((Interpolator)this.interpolator);
                try {
                    this.thumbnail.checkMisconfigured(this.defaultInstances);
                }
                catch (BeanMisconfiguredException e) {
                    throw new CreateException("An error occurred creating thumbnail outlining", (HasFriendlyErrorMessage)e);
                }
            }
            try {
                return new ListWithThumbnails(inputs, this.thumbnail.start(objects, this.scaledBoundingBoxes(inputs), Optional.of(energyStack.asStack()), context.getExecutionTimeRecorder()));
            }
            catch (OperationFailedException e) {
                throw new CreateException((Throwable)e);
            }
        }
        return new ListWithThumbnails(inputs);
    }

    public abstract ObjectCollection objectsForThumbnail(T var1) throws CreateException;

    protected abstract List<T> startBatchDeriveInputs(ObjectCollection var1, EnergyStack var2, Logger var3) throws CreateException;

    protected abstract BoundingBox boundingBoxThatSpansInput(T var1);

    private StreamableCollection<BoundingBox> scaledBoundingBoxes(List<T> inputs) {
        return new StreamableCollection(() -> inputs.stream().map(this::boundingBoxThatSpansInput));
    }

    public CombineObjectsForFeatures() {
    }

    public ThumbnailFromObjects getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(ThumbnailFromObjects thumbnail) {
        this.thumbnail = thumbnail;
    }

    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
    }
}

