/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.pair;

import java.util.Optional;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.feature.calculate.cache.CalculateForChild;
import org.anchoranalysis.feature.calculate.cache.ChildCacheName;
import org.anchoranalysis.feature.calculate.cache.part.ResolvedPart;
import org.anchoranalysis.feature.calculate.part.CalculationPart;
import org.anchoranalysis.feature.calculate.part.CalculationPartResolver;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.image.feature.calculation.CalculateInputFromPair;
import org.anchoranalysis.image.feature.input.FeatureInputPairObjects;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.image.voxel.object.morphological.MorphologicalErosion;
import org.anchoranalysis.plugin.image.feature.bean.morphological.MorphologicalIterations;
import org.anchoranalysis.plugin.image.feature.bean.object.pair.CalculateDilatedFromPair;
import org.anchoranalysis.spatial.box.Extent;

class CalculatePairIntersection
extends CalculationPart<Optional<ObjectMask>, FeatureInputPairObjects> {
    private final boolean do3D;
    private final int iterationsErosion;
    private final ResolvedPart<ObjectMask, FeatureInputPairObjects> first;
    private final ResolvedPart<ObjectMask, FeatureInputPairObjects> second;

    public static ResolvedPart<Optional<ObjectMask>, FeatureInputPairObjects> of(FeatureCalculationInput<FeatureInputPairObjects> cache, ChildCacheName cacheLeft, ChildCacheName cacheRight, MorphologicalIterations iterations, int iterationsSecond) {
        return cache.resolver().search((CalculationPart)new CalculatePairIntersection(iterations.isDo3D(), iterations.getIterationsErosion(), (ResolvedPart<ObjectMask, FeatureInputPairObjects>)cache.resolver().search(CalculateDilatedFromPair.of((CalculationPartResolver<FeatureInputPairObjects>)cache.resolver(), (CalculateForChild<FeatureInputPairObjects>)cache.forChild(), CalculateInputFromPair.Extract.FIRST, cacheLeft, iterations.getIterationsDilation(), iterations.isDo3D())), (ResolvedPart<ObjectMask, FeatureInputPairObjects>)cache.resolver().search(CalculateDilatedFromPair.of((CalculationPartResolver<FeatureInputPairObjects>)cache.resolver(), (CalculateForChild<FeatureInputPairObjects>)cache.forChild(), CalculateInputFromPair.Extract.SECOND, cacheRight, iterationsSecond, iterations.isDo3D()))));
    }

    protected Optional<ObjectMask> execute(FeatureInputPairObjects input) throws FeatureCalculationException {
        ObjectMask object2Dilated;
        Extent extent = input.dimensionsRequired().extent();
        ObjectMask object1Dilated = (ObjectMask)this.first.getOrCalculate((FeatureInput)input);
        Optional omIntersection = object1Dilated.intersect(object2Dilated = (ObjectMask)this.second.getOrCalculate((FeatureInput)input), extent);
        if (!omIntersection.isPresent()) {
            return Optional.empty();
        }
        assert (((ObjectMask)omIntersection.get()).voxelsOn().anyExists());
        try {
            if (this.iterationsErosion > 0) {
                return this.erode(input, (ObjectMask)omIntersection.get(), extent);
            }
            return omIntersection;
        }
        catch (CreateException e) {
            throw new FeatureCalculationException((Throwable)e);
        }
    }

    private Optional<ObjectMask> erode(FeatureInputPairObjects input, ObjectMask intersection, Extent extent) throws CreateException {
        ObjectMask eroded = MorphologicalErosion.erode((ObjectMask)input.getMerged(), (int)this.iterationsErosion, (boolean)this.do3D);
        return intersection.intersect(eroded, extent);
    }

    public CalculatePairIntersection(boolean do3D, int iterationsErosion, ResolvedPart<ObjectMask, FeatureInputPairObjects> first, ResolvedPart<ObjectMask, FeatureInputPairObjects> second) {
        this.do3D = do3D;
        this.iterationsErosion = iterationsErosion;
        this.first = first;
        this.second = second;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculatePairIntersection)) {
            return false;
        }
        CalculatePairIntersection other = (CalculatePairIntersection)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.do3D != other.do3D) {
            return false;
        }
        if (this.iterationsErosion != other.iterationsErosion) {
            return false;
        }
        ResolvedPart<ObjectMask, FeatureInputPairObjects> this$first = this.first;
        ResolvedPart<ObjectMask, FeatureInputPairObjects> other$first = other.first;
        if (this$first == null ? other$first != null : !this$first.equals(other$first)) {
            return false;
        }
        ResolvedPart<ObjectMask, FeatureInputPairObjects> this$second = this.second;
        ResolvedPart<ObjectMask, FeatureInputPairObjects> other$second = other.second;
        return !(this$second == null ? other$second != null : !this$second.equals(other$second));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CalculatePairIntersection;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.do3D ? 79 : 97);
        result = result * 59 + this.iterationsErosion;
        ResolvedPart<ObjectMask, FeatureInputPairObjects> $first = this.first;
        result = result * 59 + ($first == null ? 43 : $first.hashCode());
        ResolvedPart<ObjectMask, FeatureInputPairObjects> $second = this.second;
        result = result * 59 + ($second == null ? 43 : $second.hashCode());
        return result;
    }
}

