/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.pair.overlap;

import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.image.bean.unitvalue.distance.UnitValueDistance;
import org.anchoranalysis.image.core.dimensions.UnitConverter;
import org.anchoranalysis.image.feature.bean.object.pair.FeaturePairObjects;
import org.anchoranalysis.image.feature.input.FeatureInputPairObjects;
import org.anchoranalysis.plugin.image.feature.bean.object.pair.overlap.OverlapRatioUtilities;
import org.anchoranalysis.spatial.orientation.DirectionVector;
import org.anchoranalysis.spatial.point.Point3d;

public class CostOverlapWithinMidpointDistance
extends FeaturePairObjects {
    @BeanField
    private UnitValueDistance maxDistance;
    @BeanField
    private double minOverlap = 0.6;
    @BeanField
    private boolean suppressZ = true;

    public double calculate(FeatureCalculationInput<FeatureInputPairObjects> input) throws FeatureCalculationException {
        FeatureInputPairObjects inputSessionless = (FeatureInputPairObjects)input.get();
        if (this.isDistanceMoreThanMax(inputSessionless)) {
            return 1.0;
        }
        double overlapRatio = OverlapRatioUtilities.overlapRatioToMaxVolume(inputSessionless);
        if (overlapRatio > this.minOverlap) {
            return 1.0 - overlapRatio;
        }
        return 1.0;
    }

    private boolean isDistanceMoreThanMax(FeatureInputPairObjects input) throws FeatureCalculationException {
        if (!input.getUnitConverterOptional().isPresent()) {
            throw new FeatureCalculationException("This feature requires an image-resolution in the input");
        }
        Point3d cog1 = input.getFirst().centerOfGravity();
        Point3d cog2 = input.getSecond().centerOfGravity();
        double distance = this.calculateDistance(cog1, cog2);
        try {
            return distance > this.calculateMaxDistance(cog1, cog2, input.getUnitConverterOptional());
        }
        catch (OperationFailedException e) {
            throw new FeatureCalculationException((Throwable)e);
        }
    }

    private double calculateDistance(Point3d cog1, Point3d cog2) {
        if (this.suppressZ) {
            cog1.setZ(0);
            cog2.setZ(0);
        }
        return cog1.distance(cog2);
    }

    private double calculateMaxDistance(Point3d cog1, Point3d cog2, Optional<UnitConverter> unitConverter) throws OperationFailedException {
        DirectionVector vec = DirectionVector.createBetweenTwoPoints((Point3d)cog1, (Point3d)cog2);
        return this.maxDistance.resolve(unitConverter, vec);
    }

    public UnitValueDistance getMaxDistance() {
        return this.maxDistance;
    }

    public void setMaxDistance(UnitValueDistance maxDistance) {
        this.maxDistance = maxDistance;
    }

    public double getMinOverlap() {
        return this.minOverlap;
    }

    public void setMinOverlap(double minOverlap) {
        this.minOverlap = minOverlap;
    }

    public boolean isSuppressZ() {
        return this.suppressZ;
    }

    public void setSuppressZ(boolean suppressZ) {
        this.suppressZ = suppressZ;
    }
}

