/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.pair.touching;

import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.kernel.ApplyKernel;
import org.anchoranalysis.image.voxel.kernel.KernelApplicationParameters;
import org.anchoranalysis.image.voxel.kernel.count.CountKernel;
import org.anchoranalysis.image.voxel.kernel.count.CountKernelNeighborhoodMask;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.feature.bean.object.pair.touching.RelativeUtilities;
import org.anchoranalysis.plugin.image.feature.bean.object.pair.touching.TouchingVoxels;
import org.anchoranalysis.spatial.box.BoundingBox;

public class NumberTouchingVoxels
extends TouchingVoxels {
    @Override
    protected double calculateWithIntersection(ObjectMask object1, ObjectMask object2, BoundingBox boxIntersect) throws FeatureCalculationException {
        try {
            return Math.max(this.numberTouchingFrom(object1, object2, boxIntersect), this.numberTouchingFrom(object2, object1, boxIntersect));
        }
        catch (OperationFailedException e) {
            throw new FeatureCalculationException((Throwable)e);
        }
    }

    private int numberTouchingFrom(ObjectMask source, ObjectMask destination, BoundingBox boxIntersect) throws OperationFailedException {
        BoundingBox boxIntersectRelative = RelativeUtilities.relativizeBox(boxIntersect, source);
        return this.calculateNeighborhoodTouchingPixels(source, destination, boxIntersectRelative);
    }

    private int calculateNeighborhoodTouchingPixels(ObjectMask source, ObjectMask destination, BoundingBox boxIntersectRelative) throws OperationFailedException {
        CountKernelNeighborhoodMask kernelMatch = new CountKernelNeighborhoodMask(RelativeUtilities.relativizeObject(destination, source));
        return ApplyKernel.applyForCount((CountKernel)kernelMatch, (BinaryVoxels)source.binaryVoxels(), (BoundingBox)boxIntersectRelative, (KernelApplicationParameters)this.createParameters());
    }
}

